/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;

public final class Settings {
    private static final Logger LOGGER = Logger.getLogger(Settings.class.getName());
    private static final String PROPERTIES_FILE = "dependencycheck.properties";
    private static ThreadLocal<Settings> localSettings = new ThreadLocal();
    private Properties props = null;
    private static File tempDirectory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings() {
        InputStream in = null;
        this.props = new Properties();
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            this.props.load(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Unable to load default settings.");
            LOGGER.log(Level.FINE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        Settings.logProperties("Properties loaded", this.props);
    }

    public static void initialize() {
        localSettings.set(new Settings());
    }

    public static void cleanup(boolean deleteTemporary) {
        if (deleteTemporary && tempDirectory != null && tempDirectory.exists()) {
            FileUtils.delete(tempDirectory);
        }
        try {
            localSettings.remove();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.FINE, "Error cleaning up Settings", ex);
        }
    }

    public static Settings getInstance() {
        return localSettings.get();
    }

    public static void setInstance(Settings instance) {
        localSettings.set(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logProperties(String header, Properties properties) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(sw);
                pw.format("%s:%n%n", header);
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.contains("password")) {
                        pw.format("%s='*****'%n", key);
                        continue;
                    }
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    pw.format("%s='%s'%n", key, value);
                }
                pw.flush();
                LOGGER.fine(sw.toString());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    public static void setString(String key, String value) {
        Settings.localSettings.get().props.setProperty(key, value);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Setting: %s='%s'", key, value));
        }
    }

    public static void setBoolean(String key, boolean value) {
        if (value) {
            Settings.localSettings.get().props.setProperty(key, Boolean.TRUE.toString());
        } else {
            Settings.localSettings.get().props.setProperty(key, Boolean.FALSE.toString());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Setting: %s='%b'", key, value));
        }
    }

    public static void mergeProperties(File filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        Settings.mergeProperties(fis);
    }

    public static void mergeProperties(String filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        Settings.mergeProperties(fis);
    }

    public static void mergeProperties(InputStream stream) throws IOException {
        Settings.localSettings.get().props.load(stream);
        Settings.logProperties("Properties updated via merge", Settings.localSettings.get().props);
    }

    public static File getFile(String key) {
        String file = Settings.getString(key);
        if (file == null) {
            return null;
        }
        return new File(file);
    }

    public static File getDataFile(String key) {
        String file = Settings.getString(key);
        LOGGER.log(Level.FINE, String.format("Settings.getDataFile() - file: '%s'", file));
        if (file == null) {
            return null;
        }
        if (file.startsWith("[JAR]")) {
            LOGGER.log(Level.FINE, "Settings.getDataFile() - transforming filename");
            File jarPath = Settings.getJarPath();
            LOGGER.log(Level.FINE, String.format("Settings.getDataFile() - jar file: '%s'", jarPath.toString()));
            File retVal = new File(jarPath, file.substring(6));
            LOGGER.log(Level.FINE, String.format("Settings.getDataFile() - returning: '%s'", retVal.toString()));
            return retVal;
        }
        return new File(file);
    }

    private static File getJarPath() {
        String jarPath = Settings.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = ".";
        try {
            decodedPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.FINEST, null, ex);
        }
        File path = new File(decodedPath);
        if (path.getName().toLowerCase().endsWith(".jar")) {
            return path.getParentFile();
        }
        return new File(".");
    }

    public static String getString(String key, String defaultValue) {
        String str = System.getProperty(key, Settings.localSettings.get().props.getProperty(key, defaultValue));
        return str;
    }

    public static File getTempDirectory() throws IOException {
        File tmpDir = new File(Settings.getString("temp.directory", System.getProperty("java.io.tmpdir")));
        if (!tmpDir.exists()) {
            if (!tmpDir.mkdirs()) {
                String msg = String.format("Unable to make a temporary folder '%s'", tmpDir.getPath());
                throw new IOException(msg);
            }
            tempDirectory = tmpDir;
        }
        return tmpDir;
    }

    public static String getString(String key) {
        return System.getProperty(key, Settings.localSettings.get().props.getProperty(key));
    }

    public static void removeProperty(String key) {
        Settings.localSettings.get().props.remove(key);
    }

    public static int getInt(String key) throws InvalidSettingException {
        int value;
        try {
            value = Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static int getInt(String key, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            String msg = String.format("Could not convert property '%s' to an int.", key);
            LOGGER.log(Level.FINEST, msg, ex);
            value = defaultValue;
        }
        return value;
    }

    public static long getLong(String key) throws InvalidSettingException {
        long value;
        try {
            value = Long.parseLong(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static boolean getBoolean(String key) throws InvalidSettingException {
        boolean value;
        try {
            value = Boolean.parseBoolean(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) throws InvalidSettingException {
        boolean value;
        try {
            String strValue = Settings.getString(key);
            if (strValue == null) {
                return defaultValue;
            }
            value = Boolean.parseBoolean(strValue);
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static final class KEYS {
        public static final String AUTO_UPDATE = "autoupdate";
        public static final String DB_DRIVER_NAME = "data.driver_name";
        public static final String DB_DRIVER_PATH = "data.driver_path";
        public static final String DB_CONNECTION_STRING = "data.connection_string";
        public static final String DB_USER = "data.user";
        public static final String DB_PASSWORD = "data.password";
        public static final String DATA_DIRECTORY = "data.directory";
        public static final String CVE_META_URL = "cve.url.meta";
        public static final String CVE_MODIFIED_20_URL = "cve.url-2.0.modified";
        public static final String CVE_MODIFIED_12_URL = "cve.url-1.2.modified";
        public static final String CVE_MODIFIED_VALID_FOR_DAYS = "cve.url.modified.validfordays";
        public static final String CVE_START_YEAR = "cve.startyear";
        public static final String CVE_SCHEMA_1_2 = "cve.url-1.2.base";
        public static final String CVE_SCHEMA_2_0 = "cve.url-2.0.base";
        public static final String PROXY_URL = "proxy.url";
        public static final String PROXY_PORT = "proxy.port";
        public static final String PROXY_USERNAME = "proxy.username";
        public static final String PROXY_PASSWORD = "proxy.password";
        public static final String CONNECTION_TIMEOUT = "connection.timeout";
        public static final String TEMP_DIRECTORY = "temp.directory";
        public static final String MAX_DOWNLOAD_THREAD_POOL_SIZE = "max.download.threads";
        public static final String SUPPRESSION_FILE = "suppression.file";
        public static final String ANALYZER_JAR_ENABLED = "analyzer.jar.enabled";
        public static final String ANALYZER_ARCHIVE_ENABLED = "analyzer.archive.enabled";
        public static final String ANALYZER_ASSEMBLY_ENABLED = "analyzer.assembly.enabled";
        public static final String ANALYZER_NUSPEC_ENABLED = "analyzer.nuspec.enabled";
        public static final String ANALYZER_JAVASCRIPT_ENABLED = "analyzer.javascript.enabled";
        public static final String ANALYZER_NEXUS_ENABLED = "analyzer.nexus.enabled";
        public static final String ANALYZER_NEXUS_URL = "analyzer.nexus.url";
        public static final String ANALYZER_NEXUS_PROXY = "analyzer.nexus.proxy";
        public static final String ANALYZER_ASSEMBLY_MONO_PATH = "analyzer.assembly.mono.path";
        public static final String ADDITIONAL_ZIP_EXTENSIONS = "extensions.zip";
        public static final String SKIP_TEST_SCOPE = "skip.test.scope";
        public static final String SKIP_RUNTIME_SCOPE = "skip.runtime.scope";
        public static final String SKIP_PROVIDED_SCOPE = "skip.provided.scope";

        private KEYS() {
        }
    }
}

