/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.cpe.CpeMemoryIndex;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.UpdateService;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.NoDataException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class Engine {
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private final EnumMap<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap(AnalysisPhase.class);
    private final Set<FileTypeAnalyzer> fileTypeAnalyzers = new HashSet<FileTypeAnalyzer>();
    private ClassLoader serviceClassLoader;
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());

    public Engine() throws DatabaseException {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Engine(ClassLoader serviceClassLoader) throws DatabaseException {
        this.serviceClassLoader = serviceClassLoader;
        ConnectionFactory.initialize();
        boolean autoUpdate = true;
        try {
            autoUpdate = Settings.getBoolean("autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.log(Level.FINE, "Invalid setting for auto-update; using true.");
        }
        if (autoUpdate) {
            this.doUpdates();
        }
        this.loadAnalyzers();
    }

    public void cleanup() {
        ConnectionFactory.cleanup();
    }

    private void loadAnalyzers() {
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            this.analyzers.put(phase, new ArrayList());
        }
        AnalyzerService service = new AnalyzerService(this.serviceClassLoader);
        Iterator<Analyzer> iterator = service.getAnalyzers();
        while (iterator.hasNext()) {
            Analyzer a = iterator.next();
            this.analyzers.get((Object)a.getAnalysisPhase()).add(a);
            if (!(a instanceof FileTypeAnalyzer)) continue;
            this.fileTypeAnalyzers.add((FileTypeAnalyzer)a);
        }
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void scan(String[] paths) {
        for (String path : paths) {
            File file = new File(path);
            this.scan(file);
        }
    }

    public void scan(String path) {
        if (path.matches("^.*[\\/]\\*\\.[^\\/:*|?<>\"]+$")) {
            String[] parts = path.split("\\*\\.");
            String[] ext = new String[]{parts[parts.length - 1]};
            File dir = new File(path.substring(0, path.length() - ext[0].length() - 2));
            if (dir.isDirectory()) {
                List files = (List)org.apache.commons.io.FileUtils.listFiles((File)dir, (String[])ext, (boolean)true);
                this.scan(files);
            } else {
                String msg = String.format("Invalid file path provided to scan '%s'", path);
                LOGGER.log(Level.SEVERE, msg);
            }
        } else {
            File file = new File(path);
            this.scan(file);
        }
    }

    public void scan(File[] files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(Set<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(List<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
            } else {
                this.scanFile(file);
            }
        }
    }

    protected void scanDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.scanDirectory(f);
                    continue;
                }
                this.scanFile(f);
            }
        }
    }

    protected void scanFile(File file) {
        if (!file.isFile()) {
            String msg = String.format("Path passed to scanFile(File) is not a file: %s. Skipping the file.", file.toString());
            LOGGER.log(Level.FINE, msg);
            return;
        }
        String fileName = file.getName();
        String extension = FileUtils.getFileExtension(fileName);
        if (extension != null) {
            if (this.supportsExtension(extension)) {
                Dependency dependency = new Dependency(file);
                this.dependencies.add(dependency);
            }
        } else {
            String msg = String.format("No file extension found on file '%s'. The file was not analyzed.", file.toString());
            LOGGER.log(Level.FINEST, msg);
        }
    }

    public void analyzeDependencies() {
        List<Analyzer> analyzerList;
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            String msg = String.format("%s%n%nUnable to continue dependency-check analysis.", ex.getMessage());
            LOGGER.log(Level.SEVERE, msg);
            LOGGER.log(Level.FINE, null, ex);
            return;
        }
        catch (DatabaseException ex) {
            String msg = String.format("%s%n%nUnable to continue dependency-check analysis.", ex.getMessage());
            LOGGER.log(Level.SEVERE, msg);
            LOGGER.log(Level.FINE, null, ex);
            return;
        }
        String logHeader = String.format("%n----------------------------------------------------%nBEGIN ANALYSIS%n----------------------------------------------------", new Object[0]);
        LOGGER.log(Level.FINE, logHeader);
        LOGGER.log(Level.INFO, "Analysis Starting");
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                this.initializeAnalyzer(a);
                String msg = String.format("Begin Analyzer '%s'", a.getName());
                LOGGER.log(Level.FINE, msg);
                HashSet<Dependency> dependencySet = new HashSet<Dependency>();
                dependencySet.addAll(this.dependencies);
                for (Dependency d : dependencySet) {
                    boolean shouldAnalyze = true;
                    if (a instanceof FileTypeAnalyzer) {
                        FileTypeAnalyzer fAnalyzer = (FileTypeAnalyzer)a;
                        shouldAnalyze = fAnalyzer.supportsExtension(d.getFileExtension());
                    }
                    if (!shouldAnalyze) continue;
                    String msgFile = String.format("Begin Analysis of '%s'", d.getActualFilePath());
                    LOGGER.log(Level.FINE, msgFile);
                    try {
                        a.analyze(d, this);
                    }
                    catch (AnalysisException ex) {
                        String exMsg = String.format("An error occurred while analyzing '%s'.", d.getActualFilePath());
                        LOGGER.log(Level.WARNING, exMsg);
                        LOGGER.log(Level.FINE, "", ex);
                    }
                    catch (Throwable ex) {
                        String axMsg = String.format("An unexpected error occurred during analysis of '%s'", d.getActualFilePath());
                        LOGGER.log(Level.WARNING, axMsg);
                        LOGGER.log(Level.FINE, "", ex);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                this.closeAnalyzer(a);
            }
        }
        String logFooter = String.format("%n----------------------------------------------------%nEND ANALYSIS%n----------------------------------------------------", new Object[0]);
        LOGGER.log(Level.FINE, logFooter);
        LOGGER.log(Level.INFO, "Analysis Complete");
    }

    private void initializeAnalyzer(Analyzer analyzer) {
        try {
            String msg = String.format("Initializing %s", analyzer.getName());
            LOGGER.log(Level.FINE, msg);
            analyzer.initialize();
        }
        catch (Throwable ex) {
            String msg = String.format("Exception occurred initializing %s.", analyzer.getName());
            LOGGER.log(Level.SEVERE, msg);
            LOGGER.log(Level.FINE, null, ex);
            try {
                analyzer.close();
            }
            catch (Throwable ex1) {
                LOGGER.log(Level.FINEST, null, ex1);
            }
        }
    }

    private void closeAnalyzer(Analyzer analyzer) {
        String msg = String.format("Closing Analyzer '%s'", analyzer.getName());
        LOGGER.log(Level.FINE, msg);
        try {
            analyzer.close();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.FINEST, null, ex);
        }
    }

    private void doUpdates() {
        UpdateService service = new UpdateService(this.serviceClassLoader);
        Iterator<CachedWebDataSource> iterator = service.getDataSources();
        while (iterator.hasNext()) {
            CachedWebDataSource source = iterator.next();
            try {
                source.update();
            }
            catch (UpdateException ex) {
                LOGGER.log(Level.WARNING, "Unable to update Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                LOGGER.log(Level.FINE, String.format("Unable to update details for %s", source.getClass().getName()), ex);
            }
        }
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            ret.addAll(analyzerList);
        }
        return ret;
    }

    public boolean supportsExtension(String ext) {
        if (ext == null) {
            return false;
        }
        boolean scan = false;
        for (FileTypeAnalyzer a : this.fileTypeAnalyzers) {
            scan |= a.supportsExtension(ext);
        }
        return scan;
    }

    private void ensureDataExists() throws NoDataException, DatabaseException {
        CpeMemoryIndex cpe = CpeMemoryIndex.getInstance();
        CveDB cve = new CveDB();
        try {
            cve.open();
            cpe.open(cve);
        }
        catch (IndexException ex) {
            throw new NoDataException(ex.getMessage(), ex);
        }
        catch (DatabaseException ex) {
            throw new NoDataException(ex.getMessage(), ex);
        }
        finally {
            cve.close();
        }
        if (cpe.numDocs() <= 0) {
            cpe.close();
            throw new NoDataException("No documents exist");
        }
    }
}

