/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.cpe.IndexEntry;

public class VulnerableSoftware
extends IndexEntry
implements Serializable,
Comparable<VulnerableSoftware> {
    private static final long serialVersionUID = 307319490326651052L;
    private String previousVersion;
    private String name;
    private String version;
    private String revision;
    private String edition;

    public void setCpe(String cpe) {
        try {
            this.parseName(cpe);
        }
        catch (UnsupportedEncodingException ex) {
            String msg = String.format("Character encoding is unsupported for CPE '%s'.", cpe);
            Logger.getLogger(VulnerableSoftware.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(VulnerableSoftware.class.getName()).log(Level.FINE, null, ex);
            this.setName(cpe);
        }
    }

    @Override
    public void parseName(String cpeName) throws UnsupportedEncodingException {
        this.name = cpeName;
        if (cpeName != null && cpeName.length() > 7) {
            String[] data = cpeName.substring(7).split(":");
            if (data.length >= 1) {
                this.setVendor(URLDecoder.decode(data[0].replace("+", "%2B"), "UTF-8"));
            }
            if (data.length >= 2) {
                this.setProduct(URLDecoder.decode(data[1].replace("+", "%2B"), "UTF-8"));
            }
            if (data.length >= 3) {
                this.version = URLDecoder.decode(data[2].replace("+", "%2B"), "UTF-8");
            }
            if (data.length >= 4) {
                this.revision = URLDecoder.decode(data[3].replace("+", "%2B"), "UTF-8");
            }
            if (data.length >= 5) {
                this.edition = URLDecoder.decode(data[4].replace("+", "%2B"), "UTF-8");
            }
        }
    }

    public boolean hasPreviousVersion() {
        return this.previousVersion != null;
    }

    public String getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VulnerableSoftware other = (VulnerableSoftware)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "VulnerableSoftware{ name=" + this.name + ", previousVersion=" + this.previousVersion + '}';
    }

    @Override
    public int compareTo(VulnerableSoftware vs) {
        String[] right;
        int max;
        int result = 0;
        String[] left = this.getName().split(":");
        int n = max = left.length <= (right = vs.getName().split(":")).length ? left.length : right.length;
        if (max > 0) {
            for (int i = 0; result == 0 && i < max; ++i) {
                String[] subRight;
                int subMax;
                String[] subLeft = left[i].split("\\.");
                int n2 = subMax = subLeft.length <= (subRight = right[i].split("\\.")).length ? subLeft.length : subRight.length;
                if (subMax > 0) {
                    for (int x = 0; result == 0 && x < subMax; ++x) {
                        if (VulnerableSoftware.isPositiveInteger(subLeft[x]) && VulnerableSoftware.isPositiveInteger(subRight[x])) {
                            try {
                                result = Long.valueOf(subLeft[x]).compareTo(Long.valueOf(subRight[x]));
                            }
                            catch (NumberFormatException ex) {
                                if (subLeft[x].equalsIgnoreCase(subRight[x])) continue;
                                result = subLeft[x].compareToIgnoreCase(subRight[x]);
                            }
                            continue;
                        }
                        result = subLeft[x].compareToIgnoreCase(subRight[x]);
                    }
                    if (result != 0) continue;
                    if (subLeft.length > subRight.length) {
                        result = 2;
                    }
                    if (subRight.length <= subLeft.length) continue;
                    result = -2;
                    continue;
                }
                result = left[i].compareToIgnoreCase(right[i]);
            }
            if (result == 0) {
                if (left.length > right.length) {
                    result = 2;
                }
                if (right.length > left.length) {
                    result = -2;
                }
            }
        } else {
            result = this.getName().compareToIgnoreCase(vs.getName());
        }
        return result;
    }

    private static boolean isPositiveInteger(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }
}

