/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.utils.DependencyVersion;

public final class DependencyVersionUtil {
    private static final Pattern RX_VERSION = Pattern.compile("\\d+(\\.\\d{1,6})+(\\.?([_-](release|beta|alpha)|[a-zA-Z_-]{1,3}\\d{1,8}))?");
    private static final Pattern RX_SINGLE_VERSION = Pattern.compile("\\d+(\\.?([_-](release|beta|alpha)|[a-zA-Z_-]{1,3}\\d{1,8}))?");

    private DependencyVersionUtil() {
    }

    public static DependencyVersion parseVersion(String text) {
        if (text == null) {
            return null;
        }
        if ("-".equals(text)) {
            DependencyVersion dv = new DependencyVersion();
            ArrayList<String> list = new ArrayList<String>();
            list.add(text);
            dv.setVersionParts(list);
            return dv;
        }
        String version = null;
        Matcher matcher = RX_VERSION.matcher(text);
        if (matcher.find()) {
            version = matcher.group();
        }
        if (matcher.find()) {
            return null;
        }
        if (version == null) {
            matcher = RX_SINGLE_VERSION.matcher(text);
            if (!matcher.find()) {
                return null;
            }
            version = matcher.group();
            if (matcher.find()) {
                return null;
            }
        }
        return new DependencyVersion(version);
    }
}

