/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.task.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;

public class CallableDownloadTask
implements Callable<Future<ProcessTask>> {
    private CveDB cveDB;
    private ExecutorService processorService;
    private NvdCveInfo nvdCveInfo;
    private File first;
    private File second;
    private Exception exception = null;

    public CallableDownloadTask(NvdCveInfo nvdCveInfo, ExecutorService processor, CveDB cveDB) {
        File file2;
        File file1;
        this.nvdCveInfo = nvdCveInfo;
        this.processorService = processor;
        this.cveDB = cveDB;
        try {
            file1 = File.createTempFile("cve" + nvdCveInfo.getId() + "_", ".xml");
            file2 = File.createTempFile("cve_1_2_" + nvdCveInfo.getId() + "_", ".xml");
        }
        catch (IOException ex) {
            return;
        }
        this.first = file1;
        this.second = file2;
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFirst() {
        return this.first;
    }

    public void setFirst(File first) {
        this.first = first;
    }

    public File getSecond() {
        return this.second;
    }

    public void setSecond(File second) {
        this.second = second;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public Future<ProcessTask> call() throws Exception {
        try {
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            URL url2 = new URL(this.nvdCveInfo.getOldSchemaVersionUrl());
            String msg = String.format("Download Started for NVD CVE - %s", this.nvdCveInfo.getId());
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.INFO, msg);
            try {
                Downloader.fetchFile(url1, this.first);
                Downloader.fetchFile(url2, this.second);
            }
            catch (DownloadFailedException ex) {
                msg = String.format("Download Failed for NVD CVE - %s%nSome CVEs may not be reported.", this.nvdCveInfo.getId());
                Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.WARNING, msg);
                Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.FINE, null, ex);
                return null;
            }
            msg = String.format("Download Complete for NVD CVE - %s", this.nvdCveInfo.getId());
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.INFO, msg);
            ProcessTask task = new ProcessTask(this.cveDB, this);
            return this.processorService.submit(task);
        }
        catch (Throwable ex) {
            String msg = String.format("An exception occurred downloading NVD CVE - %s%nSome CVEs may not be reported.", this.nvdCveInfo.getId());
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.FINE, "Download Task Failed", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        boolean deleted = false;
        try {
            if (this.first != null && this.first.exists()) {
                deleted = this.first.delete();
            }
        }
        finally {
            if (this.first != null && (this.first.exists() || !deleted)) {
                this.first.deleteOnExit();
            }
        }
        try {
            deleted = false;
            if (this.second != null && this.second.exists()) {
                deleted = this.second.delete();
            }
        }
        finally {
            if (this.second != null && (this.second.exists() || !deleted)) {
                this.second.deleteOnExit();
            }
        }
    }
}

