/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.Settings;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AssemblyAnalyzer
extends AbstractAnalyzer {
    private static final String ANALYZER_NAME = "Assembly Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> SUPORTED_EXTENSIONS = AssemblyAnalyzer.newHashSet("dll", "exe");
    private File grokAssemblyExe;
    private DocumentBuilder builder;
    private static final Logger LOG = Logger.getLogger(AbstractAnalyzer.class.getName());

    private List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (!"\\".equals(System.getProperty("file.separator"))) {
            if (Settings.getString("analyzer.assembly.mono.path") != null) {
                args.add(Settings.getString("analyzer.assembly.mono.path"));
            } else {
                args.add("mono");
            }
        }
        args.add(this.grokAssemblyExe.getPath());
        return args;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.grokAssemblyExe == null) {
            LOG.warning("GrokAssembly didn't get deployed");
            return;
        }
        List<String> args = this.buildArgumentList();
        args.add(dependency.getActualFilePath());
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            String product;
            String vendor;
            Process proc = pb.start();
            Document doc = this.builder.parse(proc.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (error != null && !"".equals(error)) {
                throw new AnalysisException(error);
            }
            String version = xpath.evaluate("/assembly/version", doc);
            if (version != null) {
                dependency.getVersionEvidence().addEvidence(new Evidence("grokassembly", "version", version, Confidence.HIGHEST));
            }
            if ((vendor = xpath.evaluate("/assembly/company", doc)) != null) {
                dependency.getVendorEvidence().addEvidence(new Evidence("grokassembly", "vendor", vendor, Confidence.HIGH));
            }
            if ((product = xpath.evaluate("/assembly/product", doc)) != null) {
                dependency.getProductEvidence().addEvidence(new Evidence("grokassembly", "product", product, Confidence.HIGH));
            }
        }
        catch (IOException ioe) {
            throw new AnalysisException(ioe);
        }
        catch (SAXException saxe) {
            throw new AnalysisException("Couldn't parse GrokAssembly result", saxe);
        }
        catch (XPathExpressionException xpe) {
            throw new AnalysisException(xpe);
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        File tempFile = File.createTempFile("GKA", ".exe");
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            fos = new FileOutputStream(tempFile);
            is = AssemblyAnalyzer.class.getClassLoader().getResourceAsStream("GrokAssembly.exe");
            byte[] buff = new byte[4096];
            int bread = -1;
            while ((bread = is.read(buff)) >= 0) {
                fos.write(buff, 0, bread);
            }
            this.grokAssemblyExe = tempFile;
            this.grokAssemblyExe.deleteOnExit();
            LOG.log(Level.FINE, "Extracted GrokAssembly.exe to {0}", this.grokAssemblyExe.getPath());
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Could not extract GrokAssembly.exe: {0}", ioe.getMessage());
            throw new AnalysisException("Could not extract GrokAssembly.exe", ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    LOG.fine("Error closing output stream");
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {
                    LOG.fine("Error closing input stream");
                }
            }
        }
        List<String> args = this.buildArgumentList();
        try {
            Process p = new ProcessBuilder(args).start();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(p.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (p.waitFor() != 1 || error == null || "".equals(error)) {
                LOG.warning("An error occured with the .NET AssemblyAnalyzer, please see the log for more details.");
                LOG.fine("GrokAssembly.exe is not working properly");
                this.grokAssemblyExe = null;
                throw new AnalysisException("Could not execute .NET AssemblyAnalyzer");
            }
        }
        catch (Throwable e) {
            LOG.warning("An error occured with the .NET AssemblyAnalyzer; this can be ignored unless you are scanning .NET dlls. Please see the log for more details.");
            LOG.log(Level.FINE, "Could not execute GrokAssembly {0}", e.getMessage());
            throw new AnalysisException("An error occured with the .NET AssemblyAnalyzer", e);
        }
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public void close() throws Exception {
        super.close();
        try {
            this.grokAssemblyExe.delete();
        }
        catch (SecurityException se) {
            LOG.fine("Can't delete temporary GrokAssembly.exe");
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return SUPORTED_EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return SUPORTED_EXTENSIONS.contains(extension);
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }
}

