/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nexus.NexusSearch;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Settings;

public class NexusAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(NexusAnalyzer.class.getName());
    private static final String ANALYZER_NAME = "Nexus Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> SUPPORTED_EXTENSIONS = NexusAnalyzer.newHashSet("jar");
    private boolean enabled = false;
    private NexusSearch searcher;

    @Override
    public void initialize() throws Exception {
        this.enabled = Settings.getBoolean("analyzer.nexus.enabled");
        LOGGER.fine("Initializing Nexus Analyzer");
        LOGGER.fine(String.format("Nexus Analyzer enabled: %s", this.enabled));
        if (this.enabled) {
            String searchUrl = Settings.getString("analyzer.nexus.url");
            LOGGER.fine(String.format("Nexus Analyzer URL: %s", searchUrl));
            try {
                this.searcher = new NexusSearch(new URL(searchUrl));
            }
            catch (MalformedURLException mue) {
                LOGGER.warning(String.format("Property %s not a valid URL. Nexus Analyzer disabled", searchUrl));
                this.enabled = false;
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return SUPPORTED_EXTENSIONS.contains(extension);
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        if (!this.enabled) {
            return;
        }
        try {
            MavenArtifact ma = this.searcher.searchSha1(dependency.getSha1sum());
            if (ma.getGroupId() != null && !"".equals(ma.getGroupId())) {
                dependency.getVendorEvidence().addEvidence("nexus", "groupid", ma.getGroupId(), Confidence.HIGH);
            }
            if (ma.getArtifactId() != null && !"".equals(ma.getArtifactId())) {
                dependency.getProductEvidence().addEvidence("nexus", "artifactid", ma.getArtifactId(), Confidence.HIGH);
            }
            if (ma.getVersion() != null && !"".equals(ma.getVersion())) {
                dependency.getVersionEvidence().addEvidence("nexus", "version", ma.getVersion(), Confidence.HIGH);
            }
            if (ma.getArtifactUrl() != null && !"".equals(ma.getArtifactUrl())) {
                dependency.addIdentifier("maven", ma.toString(), ma.getArtifactUrl(), Confidence.HIGHEST);
            }
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info(String.format("invalid sha-1 hash on %s", dependency.getFileName()));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.fine(String.format("Artificat not found in repository '%s'", dependency.getFileName()));
            LOGGER.log(Level.FINE, fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Could not connect to nexus repository", ioe);
        }
    }
}

