/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverShim;

public final class DriverLoader {
    private DriverLoader() {
    }

    public static void load(String className) throws DriverLoadException {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        DriverLoader.load(className, loader);
    }

    public static void load(String className, String pathToDriver) throws DriverLoadException {
        String[] paths;
        final URLClassLoader parent = (URLClassLoader)ClassLoader.getSystemClassLoader();
        final ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths = pathToDriver.split(File.pathSeparator)) {
            File file = new File(path);
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    try {
                        urls.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        String msg = String.format("Unable to load database driver '%s'; invalid path provided '%s'", className, f.getAbsoluteFile());
                        Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
                        throw new DriverLoadException(msg, ex);
                    }
                }
                continue;
            }
            if (!file.exists()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                String msg = String.format("Unable to load database driver '%s'; invalid path provided '%s'", className, file.getAbsoluteFile());
                Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
                throw new DriverLoadException(msg, ex);
            }
        }
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)parent);
            }
        });
        DriverLoader.load(className, loader);
    }

    private static void load(String className, ClassLoader loader) throws DriverLoadException {
        try {
            Class<?> c = loader.loadClass(className);
            Driver driver = (Driver)c.newInstance();
            DriverManager.registerDriver(new DriverShim(driver));
        }
        catch (ClassNotFoundException ex) {
            String msg = String.format("Unable to load database driver '%s'", className);
            Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
            throw new DriverLoadException(msg, ex);
        }
        catch (InstantiationException ex) {
            String msg = String.format("Unable to load database driver '%s'", className);
            Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
            throw new DriverLoadException(msg, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = String.format("Unable to load database driver '%s'", className);
            Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
            throw new DriverLoadException(msg, ex);
        }
        catch (SQLException ex) {
            String msg = String.format("Unable to load database driver '%s'", className);
            Logger.getLogger(DriverLoader.class.getName()).log(Level.FINE, msg, ex);
            throw new DriverLoadException(msg, ex);
        }
    }
}

