/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.util.Properties;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.exception.UpdateException;

public class DatabaseProperties {
    public static final String MODIFIED = "modified";
    public static final String LAST_UPDATED = "lastupdated.modified";
    public static final String LAST_UPDATED_BASE = "lastupdated.";
    private Properties properties;
    private CveDB cveDB;

    DatabaseProperties(CveDB cveDB) {
        this.cveDB = cveDB;
        this.loadProperties();
    }

    private void loadProperties() {
        this.properties = this.cveDB.getProperties();
    }

    public boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public void save(NvdCveInfo updatedValue) throws UpdateException {
        if (updatedValue == null) {
            return;
        }
        this.properties.put(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
        this.cveDB.saveProperty(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

