/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.Settings;

public final class ConnectionFactory {
    public static final String DB_SCHEMA_VERSION = "2.8";
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";

    private ConnectionFactory() {
    }

    public static Connection getConnection() throws DatabaseException {
        Connection conn = null;
        try {
            String driverName;
            Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Loading database connection");
            String connStr = ConnectionFactory.getConnectionString();
            String user = Settings.getString("data.user", "dcuser");
            String pass = Settings.getString("data.password", "DC-Pass1337!");
            Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Connection String: {0}", connStr);
            Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Database User: {0}", user);
            boolean createTables = false;
            if (connStr.startsWith("jdbc:h2:file:")) {
                createTables = ConnectionFactory.needToCreateDatabaseStructure();
                Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Need to create DB Structure: {0}", createTables);
            }
            if (!(driverName = Settings.getString("data.driver_name", "")).isEmpty()) {
                Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Loading driver: {0}", driverName);
                String driverPath = Settings.getString("data.driver_path", "");
                if (!driverPath.isEmpty()) {
                    Logger.getLogger(CveDB.class.getName()).log(Level.FINE, "Loading driver from: {0}", driverPath);
                    DriverLoader.load(driverName, driverPath);
                } else {
                    DriverLoader.load(driverName);
                }
            }
            conn = DriverManager.getConnection(connStr, user, pass);
            if (createTables) {
                ConnectionFactory.createTables(conn);
            } else {
                ConnectionFactory.ensureSchemaVersion(conn);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
            throw new DatabaseException("Unable to load database");
        }
        catch (DriverLoadException ex) {
            Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
            throw new DatabaseException("Unable to load database driver");
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
            throw new DatabaseException("Unable to connect to the database");
        }
        catch (DatabaseException ex) {
            Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
            throw new DatabaseException("Unable to create the database structure");
        }
        return conn;
    }

    private static String getConnectionString() throws IOException {
        String connStr = Settings.getString("data.connection_string", "jdbc:h2:file:%s;AUTO_SERVER=TRUE");
        if (connStr.contains("%s")) {
            String fileName = ConnectionFactory.getDataDirectory().getCanonicalPath();
            File file = new File(fileName, "cve.2.8");
            return String.format(connStr, file.getAbsolutePath());
        }
        return connStr;
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getDataFile("data.directory");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create NVD CVE Data directory");
        }
        return path;
    }

    private static boolean needToCreateDatabaseStructure() throws IOException {
        File dir = ConnectionFactory.getDataDirectory();
        String name = String.format("cve.%s.h2.db", DB_SCHEMA_VERSION);
        File file = new File(dir, name);
        return !file.exists();
    }

    private static void createTables(Connection conn) throws DatabaseException {
        Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, "Creating database structure");
        BufferedReader in = null;
        try {
            String tmp;
            InputStream is = ConnectionFactory.class.getClassLoader().getResourceAsStream(DB_STRUCTURE_RESOURCE);
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder(2110);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
            }
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(sb.toString());
            }
            catch (SQLException ex) {
                Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    private static void ensureSchemaVersion(Connection conn) throws DatabaseException {
        CallableStatement cs;
        ResultSet rs;
        block6: {
            rs = null;
            cs = null;
            try {
                cs = conn.prepareCall("SELECT value FROM properties WHERE id = 'version'");
                rs = cs.executeQuery();
                if (rs.next()) {
                    boolean isWrongSchema;
                    boolean bl = isWrongSchema = !DB_SCHEMA_VERSION.equals(rs.getString(1));
                    if (isWrongSchema) {
                        throw new DatabaseException("Incorrect database schema; unable to continue");
                    }
                    break block6;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    Logger.getLogger(ConnectionFactory.class.getName()).log(Level.FINE, null, ex);
                    throw new DatabaseException("Unable to check the database schema version");
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(cs);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(cs);
    }
}

