/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.data.cpe.CpeMemoryIndex;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.UpdateService;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.NoDataException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class Engine {
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final EnumMap<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap(AnalysisPhase.class);
    private final Set<String> extensions = new HashSet<String>();

    public Engine() {
        boolean autoUpdate = true;
        try {
            autoUpdate = Settings.getBoolean("autoupdate");
        }
        catch (InvalidSettingException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, "Invalid setting for auto-update; using true.");
        }
        if (autoUpdate) {
            this.doUpdates();
        }
        this.loadAnalyzers();
    }

    @Deprecated
    public Engine(boolean autoUpdate) {
        if (autoUpdate) {
            this.doUpdates();
        }
        this.loadAnalyzers();
    }

    private void loadAnalyzers() {
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            this.analyzers.put(phase, new ArrayList());
        }
        AnalyzerService service = AnalyzerService.getInstance();
        Iterator<Analyzer> iterator = service.getAnalyzers();
        while (iterator.hasNext()) {
            Analyzer a = iterator.next();
            this.analyzers.get((Object)a.getAnalysisPhase()).add(a);
            if (a.getSupportedExtensions() == null) continue;
            this.extensions.addAll(a.getSupportedExtensions());
        }
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void scan(String[] paths) {
        for (String path : paths) {
            File file = new File(path);
            this.scan(file);
        }
    }

    public void scan(String path) {
        File file = new File(path);
        this.scan(file);
    }

    public void scan(File[] files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(Set<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(List<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
            } else {
                this.scanFile(file);
            }
        }
    }

    protected void scanDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.scanDirectory(f);
                    continue;
                }
                this.scanFile(f);
            }
        }
    }

    protected void scanFile(File file) {
        if (!file.isFile()) {
            String msg = String.format("Path passed to scanFile(File) is not a file: %s. Skipping the file.", file.toString());
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
            return;
        }
        String fileName = file.getName();
        String extension = FileUtils.getFileExtension(fileName);
        if (extension != null) {
            if (this.extensions.contains(extension)) {
                Dependency dependency = new Dependency(file);
                this.dependencies.add(dependency);
            }
        } else {
            String msg = String.format("No file extension found on file '%s'. The file was not analyzed.", file.toString());
            Logger.getLogger(Engine.class.getName()).log(Level.FINEST, msg);
        }
    }

    public void analyzeDependencies() {
        String msg;
        List<Analyzer> analyzerList;
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            String msg2 = String.format("%s%n%nUnable to continue dependency-check analysis.", ex.getMessage());
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, msg2);
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, null, ex);
            return;
        }
        catch (DatabaseException ex) {
            String msg3 = String.format("%s%n%nUnable to continue dependency-check analysis.", ex.getMessage());
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, msg3);
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, null, ex);
            return;
        }
        String logHeader = String.format("%n----------------------------------------------------%nBEGIN ANALYSIS%n----------------------------------------------------", new Object[0]);
        Logger.getLogger(Engine.class.getName()).log(Level.FINE, logHeader);
        Logger.getLogger(Engine.class.getName()).log(Level.INFO, "Analysis Starting");
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                try {
                    msg = String.format("Initializing %s", a.getName());
                    Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                    a.initialize();
                }
                catch (Exception ex) {
                    String msg4 = String.format("Exception occurred initializing %s.", a.getName());
                    Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, msg4);
                    Logger.getLogger(Engine.class.getName()).log(Level.INFO, null, ex);
                    try {
                        a.close();
                    }
                    catch (Exception ex1) {
                        Logger.getLogger(Engine.class.getName()).log(Level.FINEST, null, ex1);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                msg = String.format("Begin Analyzer '%s'", a.getName());
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                HashSet<Dependency> dependencySet = new HashSet<Dependency>();
                dependencySet.addAll(this.dependencies);
                for (Dependency d : dependencySet) {
                    if (!a.supportsExtension(d.getFileExtension())) continue;
                    String msgFile = String.format("Begin Analysis of '%s'", d.getActualFilePath());
                    Logger.getLogger(Engine.class.getName()).log(Level.FINE, msgFile);
                    try {
                        a.analyze(d, this);
                    }
                    catch (AnalysisException ex) {
                        d.addAnalysisException(ex);
                    }
                    catch (Throwable ex) {
                        String axMsg = String.format("An unexpected error occurred during analysis of '%s'", d.getActualFilePath());
                        AnalysisException ax = new AnalysisException(axMsg, ex);
                        d.addAnalysisException(ax);
                        Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, axMsg);
                        Logger.getLogger(Engine.class.getName()).log(Level.FINE, axMsg, ex);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                msg = String.format("Closing Analyzer '%s'", a.getName());
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                try {
                    a.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Engine.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
        String logFooter = String.format("%n----------------------------------------------------%nEND ANALYSIS%n----------------------------------------------------", new Object[0]);
        Logger.getLogger(Engine.class.getName()).log(Level.FINE, logFooter);
    }

    private void doUpdates() {
        UpdateService service = UpdateService.getInstance();
        Iterator<CachedWebDataSource> iterator = service.getDataSources();
        while (iterator.hasNext()) {
            CachedWebDataSource source = iterator.next();
            try {
                source.update();
            }
            catch (UpdateException ex) {
                Logger.getLogger(Engine.class.getName()).log(Level.WARNING, "Unable to update Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, String.format("Unable to update details for %s", source.getClass().getName()), ex);
            }
        }
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            ret.addAll(analyzerList);
        }
        return ret;
    }

    public boolean supportsExtension(String ext) {
        if (ext == null) {
            return false;
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                if (a.getSupportedExtensions() == null || !a.supportsExtension(ext)) continue;
                return true;
            }
        }
        return false;
    }

    private void ensureDataExists() throws NoDataException, DatabaseException {
        CpeMemoryIndex cpe = CpeMemoryIndex.getInstance();
        CveDB cve = new CveDB();
        try {
            cve.open();
            cpe.open(cve);
        }
        catch (IndexException ex) {
            throw new NoDataException(ex.getMessage(), ex);
        }
        catch (DatabaseException ex) {
            throw new NoDataException(ex.getMessage(), ex);
        }
        finally {
            cve.close();
        }
        if (cpe.numDocs() <= 0) {
            cpe.close();
            throw new NoDataException("No documents exist");
        }
    }
}

