/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;

public class CallableDownloadTask
implements Callable<CallableDownloadTask> {
    private NvdCveInfo nvdCveInfo;
    private File first;
    private File second;
    private Exception exception = null;

    public CallableDownloadTask(NvdCveInfo nvdCveInfo, File first, File second) {
        this.nvdCveInfo = nvdCveInfo;
        this.first = first;
        this.second = second;
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFirst() {
        return this.first;
    }

    public void setFirst(File first) {
        this.first = first;
    }

    public File getSecond() {
        return this.second;
    }

    public void setSecond(File second) {
        this.second = second;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public CallableDownloadTask call() throws Exception {
        try {
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            URL url2 = new URL(this.nvdCveInfo.getOldSchemaVersionUrl());
            String msg = String.format("Download Started for NVD CVE - %s", this.nvdCveInfo.getId());
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.INFO, msg);
            Downloader.fetchFile(url1, this.first);
            Downloader.fetchFile(url2, this.second);
            msg = String.format("Download Complete for NVD CVE - %s", this.nvdCveInfo.getId());
            Logger.getLogger(CallableDownloadTask.class.getName()).log(Level.INFO, msg);
        }
        catch (DownloadFailedException ex) {
            this.exception = ex;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        boolean deleted = false;
        try {
            if (this.first != null && this.first.exists()) {
                deleted = this.first.delete();
            }
        }
        finally {
            if (this.first != null && (this.first.exists() || !deleted)) {
                this.first.deleteOnExit();
            }
        }
        try {
            deleted = false;
            if (this.second != null && this.second.exists()) {
                deleted = this.second.delete();
            }
        }
        finally {
            if (this.second != null && (this.second.exists() || !deleted)) {
                this.second.deleteOnExit();
            }
        }
    }
}

