/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.Set;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;

public class FileNameAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final String ANALYZER_NAME = "File Name Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> EXTENSIONS = null;

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        DependencyVersion version;
        File f = new File(dependency.getFileName());
        String fileName = f.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            fileName = fileName.substring(0, pos);
        }
        if ((version = DependencyVersionUtil.parseVersion(fileName)) != null) {
            dependency.getVersionEvidence().addEvidence("file", "name", version.toString(), Evidence.Confidence.HIGHEST);
            dependency.getVersionEvidence().addEvidence("file", "name", fileName, Evidence.Confidence.MEDIUM);
        }
        if (fileName.contains("-")) {
            dependency.getProductEvidence().addEvidence("file", "name", fileName, Evidence.Confidence.HIGHEST);
            dependency.getVendorEvidence().addEvidence("file", "name", fileName, Evidence.Confidence.HIGHEST);
        } else {
            dependency.getProductEvidence().addEvidence("file", "name", fileName, Evidence.Confidence.HIGH);
            dependency.getVendorEvidence().addEvidence("file", "name", fileName, Evidence.Confidence.HIGH);
        }
    }
}

