/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.data.CachedWebDataSource;
import org.owasp.dependencycheck.data.NoDataException;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.UpdateService;
import org.owasp.dependencycheck.data.cpe.CpeIndexReader;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class Engine {
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final EnumMap<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap(AnalysisPhase.class);
    private final Set<String> extensions = new HashSet<String>();

    public Engine() {
        boolean autoUpdate = true;
        try {
            autoUpdate = Settings.getBoolean("autoupdate");
        }
        catch (InvalidSettingException ex) {
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, "Invalid setting for auto-update; using true.");
        }
        if (autoUpdate) {
            this.doUpdates();
        }
        this.loadAnalyzers();
    }

    @Deprecated
    public Engine(boolean autoUpdate) {
        if (autoUpdate) {
            this.doUpdates();
        }
        this.loadAnalyzers();
    }

    private void loadAnalyzers() {
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            this.analyzers.put(phase, new ArrayList());
        }
        AnalyzerService service = AnalyzerService.getInstance();
        Iterator<Analyzer> iterator = service.getAnalyzers();
        while (iterator.hasNext()) {
            Analyzer a = iterator.next();
            this.analyzers.get((Object)a.getAnalysisPhase()).add(a);
            if (a.getSupportedExtensions() == null) continue;
            this.extensions.addAll(a.getSupportedExtensions());
        }
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void scan(String[] paths) {
        for (String path : paths) {
            File file = new File(path);
            this.scan(file);
        }
    }

    public void scan(String path) {
        File file = new File(path);
        this.scan(file);
    }

    public void scan(File[] files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(Set<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(List<File> files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    public void scan(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
            } else {
                this.scanFile(file);
            }
        }
    }

    protected void scanDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.scanDirectory(f);
                    continue;
                }
                this.scanFile(f);
            }
        }
    }

    protected void scanFile(File file) {
        if (!file.isFile()) {
            String msg = String.format("Path passed to scanFile(File) is not a file: %s. Skipping the file.", file.toString());
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
            return;
        }
        String fileName = file.getName();
        String extension = FileUtils.getFileExtension(fileName);
        if (extension != null) {
            if (this.extensions.contains(extension)) {
                Dependency dependency = new Dependency(file);
                this.dependencies.add(dependency);
            }
        } else {
            String msg = String.format("No file extension found on file '%s'. The file was not analyzed.", file.toString());
            Logger.getLogger(Engine.class.getName()).log(Level.FINEST, msg);
        }
    }

    public void analyzeDependencies() {
        String msg;
        List<Analyzer> analyzerList;
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            String msg2 = String.format("%n%n%s%n%nUnable to continue dependency-check analysis.", ex.getMessage());
            Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, msg2);
            Logger.getLogger(Engine.class.getName()).log(Level.FINE, null, ex);
            return;
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                try {
                    msg = String.format("Initializing %s", a.getName());
                    Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                    a.initialize();
                }
                catch (Exception ex) {
                    String msg3 = String.format("Exception occurred initializing %s.", a.getName());
                    Logger.getLogger(Engine.class.getName()).log(Level.SEVERE, msg3);
                    Logger.getLogger(Engine.class.getName()).log(Level.INFO, null, ex);
                    try {
                        a.close();
                    }
                    catch (Exception ex1) {
                        Logger.getLogger(Engine.class.getName()).log(Level.FINEST, null, ex1);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                msg = String.format("Begin Analyzer '%s'", a.getName());
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                HashSet<Dependency> dependencySet = new HashSet<Dependency>();
                dependencySet.addAll(this.dependencies);
                for (Dependency d : dependencySet) {
                    String msgFile = String.format("Begin Analysis of '%s'", d.getActualFilePath());
                    Logger.getLogger(Engine.class.getName()).log(Level.FINE, msgFile);
                    if (!a.supportsExtension(d.getFileExtension())) continue;
                    try {
                        a.analyze(d, this);
                    }
                    catch (AnalysisException ex) {
                        d.addAnalysisException(ex);
                    }
                }
            }
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                msg = String.format("Closing Analyzer '%s'", a.getName());
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, msg);
                try {
                    a.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Engine.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    private void doUpdates() {
        UpdateService service = UpdateService.getInstance();
        Iterator<CachedWebDataSource> iterator = service.getDataSources();
        while (iterator.hasNext()) {
            CachedWebDataSource source = iterator.next();
            try {
                source.update();
            }
            catch (UpdateException ex) {
                Logger.getLogger(Engine.class.getName()).log(Level.WARNING, "Unable to update Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                Logger.getLogger(Engine.class.getName()).log(Level.FINE, String.format("Unable to update details for %s", source.getClass().getName()), ex);
            }
        }
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            ret.addAll(analyzerList);
        }
        return ret;
    }

    public boolean supportsExtension(String ext) {
        if (ext == null) {
            return false;
        }
        for (AnalysisPhase phase : AnalysisPhase.values()) {
            List<Analyzer> analyzerList = this.analyzers.get((Object)phase);
            for (Analyzer a : analyzerList) {
                if (a.getSupportedExtensions() == null || !a.supportsExtension(ext)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataExists() throws NoDataException {
        CpeIndexReader cpe = null;
        boolean noDataExists = false;
        try {
            cpe = new CpeIndexReader();
            cpe.open();
            if (cpe.numDocs() <= 0) {
                noDataExists = true;
            }
        }
        catch (IOException ex) {
            noDataExists = true;
        }
        catch (NullPointerException ex) {
            noDataExists = true;
        }
        finally {
            if (cpe != null) {
                cpe.close();
            }
        }
        if (noDataExists) {
            throw new NoDataException("No data exists in the data store. Please check that you are able to connect to the Internet and re-run dependency-check. If the problem persists determine whether you need to set a proxy url and port.\\n\\nIf you are unable to solve this problem please contact the mailing list for help: dependency-check@googlegroups.com");
        }
    }
}

