/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.utils.InvalidSettingException;

public final class Settings {
    private static final String PROPERTIES_FILE = "dependencycheck.properties";
    private static final Settings INSTANCE = new Settings();
    private Properties props = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings() {
        InputStream in = null;
        this.props = new Properties();
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            this.props.load(in);
        }
        catch (IOException ex) {
            Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, "Unable to load default settings.");
            Logger.getLogger(Settings.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Settings.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    public static void setString(String key, String value) {
        Settings.INSTANCE.props.setProperty(key, value);
    }

    public static void setBoolean(String key, boolean value) {
        if (value) {
            Settings.INSTANCE.props.setProperty(key, Boolean.TRUE.toString());
        } else {
            Settings.INSTANCE.props.setProperty(key, Boolean.FALSE.toString());
        }
    }

    public static void mergeProperties(File filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        Settings.mergeProperties(fis);
    }

    public static void mergeProperties(String filePath) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        Settings.mergeProperties(fis);
    }

    public static void mergeProperties(InputStream stream) throws IOException {
        Settings.INSTANCE.props.load(stream);
    }

    public static File getFile(String key) {
        String file = Settings.getString(key);
        String baseDir = Settings.getString("data.directory");
        if (baseDir != null) {
            if (baseDir.startsWith("[JAR]/")) {
                File jarPath = Settings.getJarPath();
                File newBase = new File(jarPath, baseDir.substring(6));
                if ("data.directory".equals(key)) {
                    return newBase;
                }
                return new File(newBase, file);
            }
            if ("data.directory".equals(key)) {
                return new File(baseDir);
            }
            return new File(baseDir, file);
        }
        return new File(file);
    }

    private static File getJarPath() {
        String jarPath = Settings.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = ".";
        try {
            decodedPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Settings.class.getName()).log(Level.FINEST, null, ex);
        }
        File path = new File(decodedPath);
        if (path.getName().toLowerCase().endsWith(".jar")) {
            return path.getParentFile();
        }
        return new File(".");
    }

    public static String getString(String key, String defaultValue) {
        String str = System.getProperty(key, Settings.INSTANCE.props.getProperty(key, defaultValue));
        return str;
    }

    public static File getTempDirectory() {
        return new File(Settings.getString("temp.directory", System.getProperty("java.io.tmpdir")));
    }

    public static String getString(String key) {
        return System.getProperty(key, Settings.INSTANCE.props.getProperty(key));
    }

    public static void removeProperty(String key) {
        Settings.INSTANCE.props.remove(key);
    }

    public static int getInt(String key) throws InvalidSettingException {
        int value;
        try {
            value = Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static int getInt(String key, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            String msg = String.format("Could not convert property '%s' to an int.", key);
            Logger.getLogger(Settings.class.getName()).log(Level.FINEST, msg, ex);
            value = defaultValue;
        }
        return value;
    }

    public static long getLong(String key) throws InvalidSettingException {
        long value;
        try {
            value = Long.parseLong(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static boolean getBoolean(String key) throws InvalidSettingException {
        boolean value;
        try {
            value = Boolean.parseBoolean(Settings.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
        return value;
    }

    public static final class KEYS {
        public static final String AUTO_UPDATE = "autoupdate";
        public static final String DB_DRIVER = "database.drive";
        public static final String DB_CONNECTION_STRING = "database.connectionstring";
        public static final String DATA_DIRECTORY = "data.directory";
        public static final String BATCH_UPDATE_URL = "batch.update.url";
        public static final String CPE_DATA_DIRECTORY = "data.cpe";
        public static final String CVE_DATA_DIRECTORY = "data.cve";
        public static final String CVE_META_URL = "cve.url.meta";
        public static final String CVE_MODIFIED_20_URL = "cve.url-2.0.modified";
        public static final String CVE_MODIFIED_12_URL = "cve.url-1.2.modified";
        public static final String CVE_MODIFIED_VALID_FOR_DAYS = "cve.url.modified.validfordays";
        public static final String CVE_START_YEAR = "cve.startyear";
        public static final String CVE_SCHEMA_1_2 = "cve.url-1.2.base";
        public static final String CVE_SCHEMA_2_0 = "cve.url-2.0.base";
        public static final String PROXY_URL = "proxy.url";
        public static final String PROXY_PORT = "proxy.port";
        public static final String CONNECTION_TIMEOUT = "connection.timeout";
        public static final String TEMP_DIRECTORY = "temp.directory";

        private KEYS() {
        }
    }
}

