/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.owasp.dependencycheck.utils.LogFilter;

public final class LogUtils {
    private LogUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareLogger(InputStream in, String verboseLogFile) {
        try {
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration(in);
            if (verboseLogFile != null && !verboseLogFile.isEmpty()) {
                Logger logger = Logger.getLogger("");
                FileHandler handler = new FileHandler(verboseLogFile, true);
                handler.setFormatter(new SimpleFormatter());
                handler.setLevel(Level.FINE);
                handler.setFilter(new LogFilter());
                logger.addHandler(handler);
                logger.setLevel(Level.FINE);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LogUtils.class.getName()).log(Level.FINE, "IO Error preparing the logger", ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(LogUtils.class.getName()).log(Level.FINE, "Error preparing the logger", ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(LogUtils.class.getName()).log(Level.FINEST, "Error closing resource stream", ex);
                }
            }
        }
    }
}

