/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.InvalidDataException;
import org.owasp.dependencycheck.data.update.AbstractUpdateTask;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.Updateable;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class BatchUpdateTask
extends AbstractUpdateTask {
    private boolean doBatchUpdate;

    public BatchUpdateTask(DataStoreMetaInfo properties) throws MalformedURLException, DownloadFailedException, UpdateException {
        super(properties);
    }

    protected boolean isDoBatchUpdate() {
        return this.doBatchUpdate;
    }

    protected void setDoBatchUpdate(boolean doBatchUpdate) {
        this.doBatchUpdate = doBatchUpdate;
    }

    @Override
    public void update() throws UpdateException {
        if (this.getProperties().isBatchUpdateMode() && this.doBatchUpdate) {
            String batchSrc = Settings.getString("batch.update.url");
            File tmp = null;
            try {
                this.deleteExistingData();
                File dataDirectory = CveDB.getDataDirectory().getParentFile();
                URL batchUrl = new URL(batchSrc);
                if ("file".equals(batchUrl.getProtocol())) {
                    try {
                        tmp = new File(batchUrl.toURI());
                    }
                    catch (URISyntaxException ex) {
                        String msg = String.format("Invalid batch update URI: %s", batchSrc);
                        throw new UpdateException(msg, ex);
                    }
                } else if ("http".equals(batchUrl.getProtocol()) || "https".equals(batchUrl.getProtocol())) {
                    tmp = File.createTempFile("batch_", ".zip");
                    Downloader.fetchFile(batchUrl, tmp);
                }
                FileUtils.extractFiles(tmp, dataDirectory);
            }
            catch (IOException ex) {
                String msg = String.format("IO Exception Occured performing batch update using: %s", batchSrc);
                throw new UpdateException(msg, ex);
            }
            finally {
                if (tmp != null && !tmp.delete()) {
                    tmp.deleteOnExit();
                }
            }
        }
    }

    @Override
    public Updateable updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Updateable updates;
        block25: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            DataStoreMetaInfo properties = this.getProperties();
            if (!properties.isEmpty()) {
                try {
                    long lastUpdated;
                    boolean deleteAndRecreate = false;
                    if (properties.getProperty("version") == null) {
                        deleteAndRecreate = true;
                    } else {
                        try {
                            float version = Float.parseFloat(properties.getProperty("version"));
                            float currentVersion = Float.parseFloat("2.6");
                            if (currentVersion > version) {
                                deleteAndRecreate = true;
                            }
                        }
                        catch (NumberFormatException ex) {
                            deleteAndRecreate = true;
                        }
                    }
                    NvdCveInfo batchInfo = updates.get("batch");
                    if (properties.isBatchUpdateMode() && batchInfo != null && (lastUpdated = Long.parseLong(properties.getProperty("batch", "0"))) != batchInfo.getTimestamp()) {
                        deleteAndRecreate = true;
                    }
                    if (deleteAndRecreate) {
                        this.setDoBatchUpdate(properties.isBatchUpdateMode());
                        try {
                            this.deleteExistingData();
                        }
                        catch (IOException ex) {
                            String msg = "Unable to delete existing data";
                            Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.WARNING, "Unable to delete existing data");
                            Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.FINE, null, ex);
                        }
                        return updates;
                    }
                    lastUpdated = Long.parseLong(properties.getProperty("lastupdated.modified", "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    int start = Settings.getInt("cve.startyear", 2002);
                    int end = Calendar.getInstance().get(1);
                    if (lastUpdated == updates.get("modified").getTimestamp()) {
                        updates.clear();
                        this.setDoBatchUpdate(properties.isBatchUpdateMode());
                        break block25;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        updates.get("modified").setNeedsUpdate(true);
                        if (properties.isBatchUpdateMode()) {
                            this.setDoBatchUpdate(false);
                        } else {
                            for (int i = start; i <= end; ++i) {
                                updates.get(String.valueOf(i)).setNeedsUpdate(false);
                            }
                        }
                        break block25;
                    }
                    if (properties.isBatchUpdateMode()) {
                        updates.get("modified").setNeedsUpdate(true);
                        this.setDoBatchUpdate(true);
                        break block25;
                    }
                    updates.get("modified").setNeedsUpdate(false);
                    for (int i = start; i <= end; ++i) {
                        NvdCveInfo cve = updates.get(String.valueOf(i));
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(properties.getProperty("lastupdated." + String.valueOf(i), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "lastupdated.", String.valueOf(i));
                            Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != cve.getTimestamp()) continue;
                        cve.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                    Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                    Logger.getLogger(BatchUpdateTask.class.getName()).log(Level.FINE, null, ex);
                    this.setDoBatchUpdate(properties.isBatchUpdateMode());
                }
            }
        }
        return updates;
    }

    private Updateable retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        Updateable updates = new Updateable();
        updates.add("batch", Settings.getString("batch.update.url"), null, false);
        String url = Settings.getString("cve.url-2.0.modified", "");
        if (!url.isEmpty()) {
            updates.add("modified", url, Settings.getString("cve.url-1.2.modified"), false);
        }
        return updates;
    }
}

