/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;

public class FalsePositiveAnalyzer
extends AbstractAnalyzer {
    private static final Set<String> EXTENSIONS = null;
    private static final String ANALYZER_NAME = "False Positive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_IDENTIFIER_ANALYSIS;
    public static final Pattern CORE_JAVA = Pattern.compile("^cpe:/a:(sun|oracle|ibm):(j2[ems]e|java(_platfrom_micro_edition|_runtime_environment|_se|virtual_machine|se_development_kit|fx)?|jdk|jre|jsf|jsse)($|:.*)");
    public static final Pattern CORE_FILES = Pattern.compile("^((alt[-])?rt|jsf[-].*|jsse|jfxrt|jfr|jce|javaws|deploy|charsets)\\.jar$");

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency dependency, Engine engine) throws AnalysisException {
        this.removeJreEntries(dependency);
        this.removeBadMatches(dependency);
        this.removeSpuriousCPE(dependency);
        this.addFalseNegativeCPEs(dependency);
    }

    private void removeSpuriousCPE(Dependency dependency) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        ids.addAll(dependency.getIdentifiers());
        Collections.sort(ids);
        ListIterator mainItr = ids.listIterator();
        while (mainItr.hasNext()) {
            Identifier currentId = (Identifier)mainItr.next();
            VulnerableSoftware currentCpe = this.parseCpe(currentId.getType(), currentId.getValue());
            if (currentCpe == null) continue;
            ListIterator subItr = ids.listIterator(mainItr.nextIndex());
            while (subItr.hasNext()) {
                Identifier nextId = (Identifier)subItr.next();
                VulnerableSoftware nextCpe = this.parseCpe(nextId.getType(), nextId.getValue());
                if (nextCpe == null || !currentCpe.getVendor().equals(nextCpe.getVendor()) || !currentCpe.getProduct().equals(nextCpe.getProduct())) continue;
                String currentVersion = currentCpe.getVersion();
                String nextVersion = nextCpe.getVersion();
                if (currentVersion == null && nextVersion == null) {
                    Logger.getLogger(FalsePositiveAnalyzer.class.getName()).log(Level.FINE, "currentVersion and nextVersion are both null?");
                    continue;
                }
                if (currentVersion == null && nextVersion != null) {
                    dependency.getIdentifiers().remove(currentId);
                    continue;
                }
                if (nextVersion == null && currentVersion != null) {
                    dependency.getIdentifiers().remove(nextId);
                    continue;
                }
                if (currentVersion.length() < nextVersion.length()) {
                    if (!nextVersion.startsWith(currentVersion) && !"-".equals(currentVersion)) continue;
                    dependency.getIdentifiers().remove(currentId);
                    continue;
                }
                if (!currentVersion.startsWith(nextVersion) && !"-".equals(nextVersion)) continue;
                dependency.getIdentifiers().remove(nextId);
            }
        }
    }

    private void removeJreEntries(Dependency dependency) {
        Set<Identifier> identifiers = dependency.getIdentifiers();
        Iterator<Identifier> itr = identifiers.iterator();
        while (itr.hasNext()) {
            Identifier i = itr.next();
            Matcher coreCPE = CORE_JAVA.matcher(i.getValue());
            Matcher coreFiles = CORE_FILES.matcher(dependency.getFileName());
            if (!coreCPE.matches() || coreFiles.matches()) continue;
            itr.remove();
        }
    }

    private VulnerableSoftware parseCpe(String type, String value) {
        if (!"cpe".equals(type)) {
            return null;
        }
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(value);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(FalsePositiveAnalyzer.class.getName()).log(Level.FINEST, null, ex);
            return null;
        }
        return cpe;
    }

    private void removeBadMatches(Dependency dependency) {
        Set<Identifier> identifiers = dependency.getIdentifiers();
        Iterator<Identifier> itr = identifiers.iterator();
        while (itr.hasNext()) {
            Identifier i = itr.next();
            if (!"cpe".equals(i.getType())) continue;
            if ((i.getValue().matches(".*c\\+\\+.*") || i.getValue().startsWith("cpe:/a:jquery:jquery") || i.getValue().startsWith("cpe:/a:prototypejs:prototype") || i.getValue().startsWith("cpe:/a:yahoo:yui") || i.getValue().startsWith("cpe:/a:file:file") || i.getValue().startsWith("cpe:/a:mozilla:mozilla") || i.getValue().startsWith("cpe:/a:cvs:cvs") || i.getValue().startsWith("cpe:/a:ftp:ftp") || i.getValue().startsWith("cpe:/a:ssh:ssh")) && dependency.getFileName().toLowerCase().endsWith(".jar")) {
                itr.remove();
                continue;
            }
            if (!i.getValue().startsWith("cpe:/a:apache:maven") || dependency.getFileName().toLowerCase().matches("maven-core-[\\d\\.]+\\.jar")) continue;
            itr.remove();
        }
    }

    private void addFalseNegativeCPEs(Dependency dependency) {
        for (Identifier i : dependency.getIdentifiers()) {
            if (!"cpe".equals(i.getType()) || i.getValue() == null || !i.getValue().startsWith("cpe:/a:oracle:opensso:") && !i.getValue().startsWith("cpe:/a:oracle:opensso_enterprise:") && !i.getValue().startsWith("cpe:/a:sun:opensso_enterprise:") && !i.getValue().startsWith("cpe:/a:sun:opensso:")) continue;
            String newCpe = String.format("cpe:/a:sun:opensso_enterprise:%s", i.getValue().substring(22));
            String newCpe2 = String.format("cpe:/a:oracle:opensso_enterprise:%s", i.getValue().substring(22));
            String newCpe3 = String.format("cpe:/a:sun:opensso:%s", i.getValue().substring(22));
            String newCpe4 = String.format("cpe:/a:oracle:opensso:%s", i.getValue().substring(22));
            try {
                dependency.addIdentifier("cpe", newCpe, String.format("http://web.nvd.nist.gov/view/vuln/search?cpe=%s", URLEncoder.encode(newCpe, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe2, String.format("http://web.nvd.nist.gov/view/vuln/search?cpe=%s", URLEncoder.encode(newCpe2, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe3, String.format("http://web.nvd.nist.gov/view/vuln/search?cpe=%s", URLEncoder.encode(newCpe3, "UTF-8")));
                dependency.addIdentifier("cpe", newCpe4, String.format("http://web.nvd.nist.gov/view/vuln/search?cpe=%s", URLEncoder.encode(newCpe4, "UTF-8")));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(FalsePositiveAnalyzer.class.getName()).log(Level.FINE, null, ex);
            }
        }
    }
}

