/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.concurrency.DirectoryLockException;
import org.owasp.dependencycheck.concurrency.DirectorySpinLock;
import org.owasp.dependencycheck.concurrency.InvalidDirectoryException;
import org.owasp.dependencycheck.data.CachedWebDataSource;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.UpdateTask;
import org.owasp.dependencycheck.data.update.UpdateTaskFactory;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;

public class DatabaseUpdater
implements CachedWebDataSource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        block16: {
            File dataDir = Settings.getFile("data.directory");
            DirectorySpinLock lock = null;
            try {
                lock = new DirectorySpinLock(dataDir);
            }
            catch (InvalidDirectoryException ex) {
                throw new UpdateException("Unable to obtain lock on the data directory", ex);
            }
            catch (DirectoryLockException ex) {
                throw new UpdateException("Unable to obtain exclusive lock on the data directory", ex);
            }
            try {
                lock.obtainSharedLock();
                UpdateTask task = UpdateTaskFactory.getUpdateTask();
                if (!task.isUpdateNeeded()) break block16;
                lock.release();
                lock.obtainExclusiveLock();
                if (task.shouldDeleteAndRecreate()) {
                    try {
                        this.deleteExistingData();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.WARNING, "Unable to delete the existing data directory");
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
                    }
                }
                task.update();
            }
            catch (DirectoryLockException ex) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.WARNING, "Unable to obtain lock on data directory, unable to update the data to use the most current data.");
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.WARNING, "NVD CVE properties files contain an invalid URL, unable to update the data to use the most current data.");
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
            }
            catch (DownloadFailedException ex) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.WARNING, "Unable to download the NVD CVE data, unable to update the data to use the most current data.");
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
    }

    protected void deleteExistingData() throws IOException {
        File data = Settings.getFile("data.cve");
        if (data.exists()) {
            FileUtils.delete(data);
        }
        if ((data = Settings.getFile("data.cpe")).exists()) {
            FileUtils.delete(data);
        }
        if ((data = DataStoreMetaInfo.getPropertiesFile()).exists()) {
            FileUtils.delete(data);
        }
    }
}

