/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.utils.ExtractionException;

public final class FileUtils {
    private static final int BUFFER_SIZE = 4096;

    private FileUtils() {
    }

    public static String getFileExtension(String fileName) {
        String ret = null;
        int pos = fileName.lastIndexOf(".");
        if (pos >= 0) {
            ret = fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return ret;
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                FileUtils.delete(c);
            }
        }
        if (!org.apache.commons.io.FileUtils.deleteQuietly((File)file)) {
            throw new FileNotFoundException("Failed to delete file: " + file);
        }
        file.deleteOnExit();
    }

    public static void delete(File file, boolean deleteOnExit) throws IOException {
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                FileUtils.delete(c);
            }
        }
        if (!org.apache.commons.io.FileUtils.deleteQuietly((File)file)) {
            if (deleteOnExit) {
                file.deleteOnExit();
            } else {
                throw new FileNotFoundException("Failed to delete file: " + file);
            }
        }
    }

    @Deprecated
    public static File getDataDirectory(String configuredFilePath, Class clazz) throws IOException {
        File file = new File(configuredFilePath);
        if (file.isDirectory() && file.canWrite()) {
            return new File(file.getCanonicalPath());
        }
        File exePath = FileUtils.getPathToJar(clazz);
        return new File(exePath, configuredFilePath);
    }

    @Deprecated
    public static File getPathToJar(Class clazz) throws UnsupportedEncodingException {
        String filePath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        File jarPath = new File(decodedPath);
        return jarPath.getParentFile();
    }

    public static void extractFiles(File archive, File extractTo) throws ExtractionException {
        FileUtils.extractFiles(archive, extractTo, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractFiles(File archive, File extractTo, Engine engine) throws ExtractionException {
        if (archive == null) return;
        if (extractTo == null) {
            return;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FileUtils.class.getName()).log(Level.INFO, null, ex);
            throw new ExtractionException("Archive file was not found.", ex);
        }
        zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(extractTo, entry.getName());
                    if (d.exists() || d.mkdirs()) continue;
                    String msg = String.format("Unable to create '%s'.", d.getAbsolutePath());
                    throw new ExtractionException(msg);
                }
                File file = new File(extractTo, entry.getName());
                String ext = FileUtils.getFileExtension(file.getName());
                if (engine != null && !engine.supportsExtension(ext)) continue;
                FilterOutputStream bos = null;
                try {
                    int count;
                    FileOutputStream fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 4096);
                    byte[] data = new byte[4096];
                    while ((count = zis.read(data, 0, 4096)) != -1) {
                        ((BufferedOutputStream)bos).write(data, 0, count);
                    }
                    ((BufferedOutputStream)bos).flush();
                    if (bos == null) continue;
                }
                catch (FileNotFoundException ex) {
                    try {
                        Logger.getLogger(FileUtils.class.getName()).log(Level.FINE, null, ex);
                        String msg = String.format("Unable to find file '%s'.", file.getName());
                        throw new ExtractionException(msg, ex);
                        catch (IOException ex2) {
                            Logger.getLogger(FileUtils.class.getName()).log(Level.FINE, null, ex2);
                            msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                            throw new ExtractionException(msg, ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bos == null) throw throwable;
                        try {
                            bos.close();
                            throw throwable;
                        }
                        catch (IOException ex3) {
                            Logger.getLogger(FileUtils.class.getName()).log(Level.FINEST, null, ex3);
                        }
                        throw throwable;
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(FileUtils.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            return;
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            Logger.getLogger(FileUtils.class.getName()).log(Level.FINE, msg, ex);
            throw new ExtractionException(msg, ex);
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.FINEST, null, ex);
            }
        }
    }
}

