/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.data.CachedWebDataSource;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.cpe.CpeIndexWriter;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.InvalidDataException;
import org.owasp.dependencycheck.data.nvdcve.NvdCve12Handler;
import org.owasp.dependencycheck.data.nvdcve.NvdCve20Handler;
import org.owasp.dependencycheck.data.update.DataStoreMetaInfo;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseUpdater
implements CachedWebDataSource {
    private DataStoreMetaInfo properties = null;
    private CveDB cveDB = null;
    private CpeIndexWriter cpeIndex = null;
    private boolean doBatchUpdate;

    protected boolean isDoBatchUpdate() {
        return this.doBatchUpdate;
    }

    protected void setDoBatchUpdate(boolean doBatchUpdate) {
        this.doBatchUpdate = doBatchUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        this.doBatchUpdate = false;
        this.properties = new DataStoreMetaInfo();
        try {
            Map<String, NvdCveInfo> update = this.updateNeeded();
            int maxUpdates = 0;
            for (NvdCveInfo cve : update.values()) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates > 3 && !this.properties.isBatchUpdateMode()) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0 && !this.isDoBatchUpdate()) {
                this.openDataStores();
            }
            if (this.properties.isBatchUpdateMode() && this.isDoBatchUpdate()) {
                try {
                    this.performBatchUpdate();
                    this.openDataStores();
                }
                catch (IOException ex) {
                    throw new UpdateException("Unable to perform batch update", ex);
                }
            }
            int count = 0;
            for (NvdCveInfo cve : update.values()) {
                if (!cve.getNeedsUpdate()) continue;
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Updating NVD CVE ({0} of {1})", new Object[]{++count, maxUpdates});
                URL url = new URL(cve.getUrl());
                File outputPath = null;
                File outputPath12 = null;
                try {
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Downloading {0}", cve.getUrl());
                    outputPath = File.createTempFile("cve" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath);
                    url = new URL(cve.getOldSchemaVersionUrl());
                    outputPath12 = File.createTempFile("cve_1_2_" + cve.getId() + "_", ".xml");
                    Downloader.fetchFile(url, outputPath12);
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Processing {0}", cve.getUrl());
                    this.importXML(outputPath, outputPath12);
                    this.cveDB.commit();
                    this.cpeIndex.commit();
                    this.properties.save(cve);
                    Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.INFO, "Completed update {0} of {1}", new Object[]{count, maxUpdates});
                }
                catch (FileNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new UpdateException(ex);
                }
                catch (SAXException ex) {
                    throw new UpdateException(ex);
                }
                catch (IOException ex) {
                    throw new UpdateException(ex);
                }
                catch (SQLException ex) {
                    throw new UpdateException(ex);
                }
                catch (DatabaseException ex) {
                    throw new UpdateException(ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new UpdateException(ex);
                }
                finally {
                    boolean deleted = false;
                    try {
                        if (outputPath != null && outputPath.exists()) {
                            deleted = outputPath.delete();
                        }
                    }
                    finally {
                        if (outputPath != null && (outputPath.exists() || !deleted)) {
                            outputPath.deleteOnExit();
                        }
                    }
                    try {
                        deleted = false;
                        if (outputPath12 == null || !outputPath12.exists()) continue;
                        deleted = outputPath12.delete();
                    }
                    finally {
                        if (outputPath12 == null || !outputPath12.exists() && deleted) continue;
                        outputPath12.deleteOnExit();
                    }
                }
            }
            if (maxUpdates >= 1) {
                this.properties.save(update.get("modified"));
                this.cveDB.cleanupDatabase();
            }
            if (update.get("batch") != null) {
                this.properties.save(update.get("batch"));
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(ex);
        }
        catch (DownloadFailedException ex) {
            throw new UpdateException(ex);
        }
        finally {
            this.closeDataStores();
        }
    }

    private void importXML(File file, File oldVersion) throws ParserConfigurationException, SAXException, IOException, SQLException, DatabaseException, ClassNotFoundException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        NvdCve12Handler cve12Handler = new NvdCve12Handler();
        saxParser.parse(oldVersion, (DefaultHandler)cve12Handler);
        Map<String, List<VulnerableSoftware>> prevVersionVulnMap = cve12Handler.getVulnerabilities();
        NvdCve20Handler cve20Handler = new NvdCve20Handler();
        cve20Handler.setCveDB(this.cveDB);
        cve20Handler.setPrevVersionVulnMap(prevVersionVulnMap);
        cve20Handler.setCpeIndex(this.cpeIndex);
        saxParser.parse(file, (DefaultHandler)cve20Handler);
    }

    protected void deleteExistingData() throws IOException {
        File data = Settings.getFile("data.cve");
        if (data.exists()) {
            FileUtils.delete(data);
        }
        if ((data = Settings.getFile("data.cpe")).exists()) {
            FileUtils.delete(data);
        }
        if ((data = DataStoreMetaInfo.getPropertiesFile()).exists()) {
            FileUtils.delete(data);
        }
    }

    private void performBatchUpdate() throws UpdateException {
        if (this.properties.isBatchUpdateMode() && this.doBatchUpdate) {
            String batchSrc = Settings.getString("batch.update.url");
            File tmp = null;
            try {
                this.deleteExistingData();
                File dataDirectory = CveDB.getDataDirectory().getParentFile();
                URL batchUrl = new URL(batchSrc);
                if ("file".equals(batchUrl.getProtocol())) {
                    try {
                        tmp = new File(batchUrl.toURI());
                    }
                    catch (URISyntaxException ex) {
                        String msg = String.format("Invalid batch update URI: %s", batchSrc);
                        throw new UpdateException(msg, ex);
                    }
                } else if ("http".equals(batchUrl.getProtocol()) || "https".equals(batchUrl.getProtocol())) {
                    tmp = File.createTempFile("batch_", ".zip");
                    Downloader.fetchFile(batchUrl, tmp);
                }
                FileUtils.extractFiles(tmp, dataDirectory);
            }
            catch (IOException ex) {
                String msg = String.format("IO Exception Occured performing batch update using: %s", batchSrc);
                throw new UpdateException(msg, ex);
            }
            finally {
                if (tmp != null && !tmp.delete()) {
                    tmp.deleteOnExit();
                }
            }
        }
    }

    private void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
        if (this.cpeIndex != null) {
            try {
                this.cpeIndex.close();
            }
            catch (Exception ignore) {
                Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINEST, "Error closing the cpeIndex", ignore);
            }
        }
    }

    private void openDataStores() throws UpdateException {
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
            this.cpeIndex = new CpeIndexWriter();
            this.cpeIndex.open();
        }
        catch (IOException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "IO Error opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (SQLException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "SQL Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Database Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
        catch (ClassNotFoundException ex) {
            this.closeDataStores();
            Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, "Class not found exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
    }

    private Map<String, NvdCveInfo> updateNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        Map<String, NvdCveInfo> currentlyPublished;
        try {
            currentlyPublished = this.retrieveCurrentTimestampsFromWeb();
        }
        catch (InvalidDataException ex) {
            String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
        }
        catch (InvalidSettingException ex) {
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
            throw new DownloadFailedException("Invalid settings", ex);
        }
        if (currentlyPublished == null) {
            throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
        }
        if (!this.properties.isEmpty()) {
            try {
                long lastUpdated;
                boolean deleteAndRecreate = false;
                if (this.properties.getProperty("version") == null) {
                    deleteAndRecreate = true;
                } else {
                    try {
                        float version = Float.parseFloat(this.properties.getProperty("version"));
                        float currentVersion = Float.parseFloat("2.6");
                        if (currentVersion > version) {
                            deleteAndRecreate = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        deleteAndRecreate = true;
                    }
                }
                NvdCveInfo batchInfo = currentlyPublished.get("batch");
                if (this.properties.isBatchUpdateMode() && batchInfo != null && (lastUpdated = Long.parseLong(this.properties.getProperty("batch", "0"))) != batchInfo.getTimestamp()) {
                    deleteAndRecreate = true;
                }
                if (deleteAndRecreate) {
                    this.setDoBatchUpdate(this.properties.isBatchUpdateMode());
                    try {
                        this.deleteExistingData();
                    }
                    catch (IOException ex) {
                        String msg = "Unable to delete existing data";
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.WARNING, "Unable to delete existing data");
                        Logger.getLogger(DatabaseUpdater.class.getName()).log(Level.FINE, null, ex);
                    }
                    return currentlyPublished;
                }
                lastUpdated = Long.parseLong(this.properties.getProperty("lastupdated.modified", "0"));
                Date now = new Date();
                int days = Settings.getInt("cve.url.modified.validfordays", 7);
                int start = Settings.getInt("cve.startyear", 2002);
                int end = Calendar.getInstance().get(1);
                if (lastUpdated == currentlyPublished.get("modified").getTimestamp()) {
                    currentlyPublished.clear();
                    this.setDoBatchUpdate(this.properties.isBatchUpdateMode());
                }
                if (this.withinRange(lastUpdated, now.getTime(), days)) {
                    currentlyPublished.get("modified").setNeedsUpdate(true);
                    if (this.properties.isBatchUpdateMode()) {
                        this.setDoBatchUpdate(false);
                    }
                    for (int i = start; i <= end; ++i) {
                        currentlyPublished.get(String.valueOf(i)).setNeedsUpdate(false);
                    }
                }
                if (this.properties.isBatchUpdateMode()) {
                    currentlyPublished.get("modified").setNeedsUpdate(true);
                    this.setDoBatchUpdate(true);
                }
                currentlyPublished.get("modified").setNeedsUpdate(false);
                for (int i = start; i <= end; ++i) {
                    NvdCveInfo cve = currentlyPublished.get(String.valueOf(i));
                    long currentTimestamp = 0L;
                    try {
                        currentTimestamp = Long.parseLong(this.properties.getProperty("lastupdated." + String.valueOf(i), "0"));
                    }
                    catch (NumberFormatException ex) {
                        String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "lastupdated.", String.valueOf(i));
                        Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, msg, ex);
                    }
                    if (currentTimestamp != cve.getTimestamp()) continue;
                    cve.setNeedsUpdate(false);
                }
            }
            catch (NumberFormatException ex) {
                String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex);
                this.setDoBatchUpdate(this.properties.isBatchUpdateMode());
            }
        } else {
            this.setDoBatchUpdate(this.properties.isBatchUpdateMode());
        }
        return currentlyPublished;
    }

    private boolean withinRange(long date, long compareTo, int range) {
        double differenceInDays = (double)(compareTo - date) / 1000.0 / 60.0 / 60.0 / 24.0;
        return differenceInDays < (double)range;
    }

    private Map<String, NvdCveInfo> retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        TreeMap<String, NvdCveInfo> map = new TreeMap<String, NvdCveInfo>();
        String retrieveUrl = Settings.getString("cve.url-2.0.modified");
        if (retrieveUrl == null && this.properties.isBatchUpdateMode()) {
            NvdCveInfo item = new NvdCveInfo();
            retrieveUrl = Settings.getString("batch.update.url");
            if (retrieveUrl == null) {
                String msg = "Invalid configuration - neither the modified or batch update URLs are specified in the configuration.";
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.SEVERE, "Invalid configuration - neither the modified or batch update URLs are specified in the configuration.");
                throw new InvalidSettingException("Invalid configuration - neither the modified or batch update URLs are specified in the configuration.");
            }
            item.setTimestamp(Downloader.getLastModified(new URL(retrieveUrl)));
            item.setId("batch");
            item.setNeedsUpdate(false);
            map.put("batch", item);
        } else {
            NvdCveInfo item = new NvdCveInfo();
            item.setNeedsUpdate(false);
            item.setId("modified");
            item.setUrl(retrieveUrl);
            item.setOldSchemaVersionUrl(Settings.getString("cve.url-1.2.modified"));
            item.setTimestamp(Downloader.getLastModified(new URL(retrieveUrl)));
            map.put("modified", item);
            if (!this.properties.isBatchUpdateMode()) {
                int start = Settings.getInt("cve.startyear");
                int end = Calendar.getInstance().get(1);
                String baseUrl20 = Settings.getString("cve.url-2.0.base");
                String baseUrl12 = Settings.getString("cve.url-1.2.base");
                for (int i = start; i <= end; ++i) {
                    retrieveUrl = String.format(baseUrl20, i);
                    item = new NvdCveInfo();
                    item.setId(Integer.toString(i));
                    item.setUrl(retrieveUrl);
                    item.setOldSchemaVersionUrl(String.format(baseUrl12, i));
                    item.setTimestamp(Downloader.getLastModified(new URL(retrieveUrl)));
                    map.put(item.getId(), item);
                }
            }
        }
        return map;
    }
}

