/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.owasp.dependencycheck.utils.Settings;

public abstract class BaseIndex {
    private Directory directory;
    private boolean indexOpen = false;

    public Directory getDirectory() {
        return this.directory;
    }

    public void open() throws IOException {
        this.directory = this.openDirectory();
        this.indexOpen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.directory.close();
        }
        catch (IOException ex) {
            String msg = "Unable to update database due to an IO error.";
            Logger.getLogger(BaseIndex.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
            Logger.getLogger(BaseIndex.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            this.directory = null;
        }
        this.indexOpen = false;
    }

    public boolean isOpen() {
        return this.indexOpen;
    }

    protected Directory openDirectory() throws IOException {
        File path = BaseIndex.getDataDirectory();
        return FSDirectory.open((File)path);
    }

    public static File getDataDirectory() throws IOException {
        File path = Settings.getFile("data.cpe");
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create CPE Data directory");
        }
        return path;
    }
}

