/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getFileExtension(String fileName) {
        String ret = null;
        int pos = fileName.lastIndexOf(".");
        if (pos >= 0) {
            ret = fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return ret;
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                FileUtils.delete(c);
            }
        }
        if (!file.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + file);
        }
    }

    @Deprecated
    public static File getDataDirectory(String configuredFilePath, Class clazz) throws IOException {
        File file = new File(configuredFilePath);
        if (file.isDirectory() && file.canWrite()) {
            return new File(file.getCanonicalPath());
        }
        File exePath = FileUtils.getPathToJar(clazz);
        return new File(exePath, configuredFilePath);
    }

    @Deprecated
    public static File getPathToJar(Class clazz) throws UnsupportedEncodingException {
        String filePath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        File jarPath = new File(decodedPath);
        return jarPath.getParentFile();
    }
}

