/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;

public final class LuceneUtils {
    private LuceneUtils() {
    }

    @SuppressWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="The switch below does have a default.")
    public static void appendEscapedLuceneQuery(StringBuilder buf, CharSequence text) {
        if (text == null || buf == null) {
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
    }

    public static String escapeLuceneQuery(CharSequence text) {
        if (text == null) {
            return null;
        }
        int size = text.length();
        StringBuilder buf = new StringBuilder(size >>= 1);
        LuceneUtils.appendEscapedLuceneQuery(buf, text);
        return buf.toString();
    }
}

