/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public abstract class AbstractIndex {
    private Directory directory;
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private Analyzer indexingAnalyzer;
    private Analyzer searchingAnalyzer;
    private QueryParser queryParser;
    private boolean indexOpen = false;

    public void open() throws IOException {
        this.directory = this.getDirectory();
        this.indexingAnalyzer = this.getIndexingAnalyzer();
        this.searchingAnalyzer = this.getSearchingAnalyzer();
        this.indexOpen = true;
    }

    public void commit() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.commit();
            }
            catch (CorruptIndexException ex) {
                String msg = "Unable to update database, there is a corrupt index.";
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.SEVERE, "Unable to update database, there is a corrupt index.");
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.FINE, null, ex);
            }
            catch (IOException ex) {
                String msg = "Unable to update database due to an IO error.";
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.FINE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        String msg;
        if (this.indexWriter != null) {
            this.commit();
            try {
                this.indexWriter.close(true);
            }
            catch (CorruptIndexException ex) {
                msg = "Unable to update database, there is a corrupt index.";
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.SEVERE, "Unable to update database, there is a corrupt index.");
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.FINE, null, ex);
            }
            catch (IOException ex) {
                msg = "Unable to update database due to an IO error.";
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
                Logger.getLogger(AbstractIndex.class.getName()).log(Level.FINE, null, ex);
            }
            finally {
                this.indexWriter = null;
            }
        }
        if (this.indexSearcher != null) {
            this.indexSearcher = null;
        }
        if (this.indexingAnalyzer != null) {
            this.indexingAnalyzer.close();
            this.indexingAnalyzer = null;
        }
        if (this.searchingAnalyzer != null) {
            this.searchingAnalyzer.close();
            this.searchingAnalyzer = null;
        }
        try {
            this.directory.close();
        }
        catch (IOException ex) {
            msg = "Unable to update database due to an IO error.";
            Logger.getLogger(AbstractIndex.class.getName()).log(Level.SEVERE, "Unable to update database due to an IO error.");
            Logger.getLogger(AbstractIndex.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            this.directory = null;
        }
        this.indexOpen = false;
    }

    public boolean isOpen() {
        return this.indexOpen;
    }

    public void openIndexWriter() throws CorruptIndexException, IOException {
        if (!this.isOpen()) {
            this.open();
        }
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_43, this.indexingAnalyzer);
        this.indexWriter = new IndexWriter(this.directory, conf);
    }

    public IndexWriter getIndexWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        if (this.indexWriter == null) {
            this.openIndexWriter();
        }
        return this.indexWriter;
    }

    public void openIndexReader() throws CorruptIndexException, IOException {
        if (!this.isOpen()) {
            this.open();
        }
        this.indexReader = DirectoryReader.open((Directory)this.directory);
    }

    protected IndexSearcher getIndexSearcher() throws CorruptIndexException, IOException {
        if (this.indexReader == null) {
            this.openIndexReader();
        }
        if (this.indexSearcher == null) {
            this.indexSearcher = new IndexSearcher(this.indexReader);
        }
        return this.indexSearcher;
    }

    public Analyzer getIndexingAnalyzer() {
        if (this.indexingAnalyzer == null) {
            this.indexingAnalyzer = this.createIndexingAnalyzer();
        }
        return this.indexingAnalyzer;
    }

    protected Analyzer getSearchingAnalyzer() {
        if (this.searchingAnalyzer == null) {
            this.searchingAnalyzer = this.createSearchingAnalyzer();
        }
        return this.searchingAnalyzer;
    }

    protected QueryParser getQueryParser() {
        if (this.queryParser == null) {
            this.queryParser = this.createQueryParser();
        }
        return this.queryParser;
    }

    public TopDocs search(String searchString, int maxQueryResults) throws ParseException, IOException {
        QueryParser parser = this.getQueryParser();
        Query query = parser.parse(searchString);
        this.resetSearchingAnalyzer();
        IndexSearcher is = this.getIndexSearcher();
        return is.search(query, maxQueryResults);
    }

    public TopDocs search(Query query, int maxQueryResults) throws CorruptIndexException, IOException {
        IndexSearcher is = this.getIndexSearcher();
        return is.search(query, maxQueryResults);
    }

    public Document getDocument(int documentId) throws IOException {
        IndexSearcher is = this.getIndexSearcher();
        return is.doc(documentId);
    }

    public abstract Directory getDirectory() throws IOException;

    public abstract Analyzer createIndexingAnalyzer();

    public abstract Analyzer createSearchingAnalyzer();

    public abstract QueryParser createQueryParser();

    protected abstract void resetSearchingAnalyzer();
}

