/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;

public class PluginLoader {
    public static void premain(String agentArg, Instrumentation inst) {
        File pluginsDir = new File(agentArg);
        if (pluginsDir.isDirectory()) {
            File[] files = pluginsDir.listFiles((dir, name) -> name.endsWith(".jar"));
            for (File file : files == null ? new File[]{} : files) {
                try (JarFile jar = new JarFile(file);){
                    inst.appendToSystemClassLoaderSearch(jar);
                }
                catch (IOException e) {
                    System.err.printf("[WARN] Failed to read plugin jar file at %s. Jar will not be available on classpath: %s%n", file, e);
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

