/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.util.Optional;
import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.owasp.dependencycheck.utils.CveUrlParser;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String nonProxyHosts;
    private String connectionTimeout;
    private String readTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String cveUrlModified;
    private String cveUrlBase;
    private String cveWaitTime;
    private Integer cveValidForHours;
    private Integer hostedSuppressionsValidForHours;
    private Boolean hostedSuppressionsForceUpdate;
    private Boolean hostedSuppressionsEnabled;
    private Integer cveStartYear;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public void setCveUrlModified(String cveUrlModified) {
        this.cveUrlModified = cveUrlModified;
    }

    public String getCveUrlModified() {
        return this.cveUrlModified;
    }

    public String getCveUrlBase() {
        return this.cveUrlBase;
    }

    public void setCveUrlBase(String cveUrlBase) {
        this.cveUrlBase = cveUrlBase;
    }

    public String getCveWaitTime() {
        return this.cveWaitTime;
    }

    public void setCveWaitTime(String cveWaitTime) {
        this.cveWaitTime = cveWaitTime;
    }

    public Integer getCveValidForHours() {
        return this.cveValidForHours;
    }

    public void setCveValidForHours(Integer cveValidForHours) {
        this.cveValidForHours = cveValidForHours;
    }

    public Integer getCveStartYear() {
        return this.cveStartYear;
    }

    public void setCveStartYear(Integer cveStartYear) {
        if (cveStartYear != null && cveStartYear < 2002) {
            this.log("Invalid Configuration: cveStartYear must be 2002 or greater", 0);
            this.cveStartYear = 2002;
        } else {
            this.cveStartYear = cveStartYear;
        }
    }

    public Integer getHostedSuppressionsValidForHours() {
        return this.hostedSuppressionsValidForHours;
    }

    public void setHostedSuppressionsValidForHours(Integer hostedSuppressionsValidForHours) {
        this.hostedSuppressionsValidForHours = hostedSuppressionsValidForHours;
    }

    public Boolean isHostedSuppressionsForceUpdate() {
        return this.hostedSuppressionsForceUpdate;
    }

    public void setHostedSuppressionsForceUpdate(Boolean hostedSuppressionsForceUpdate) {
        this.hostedSuppressionsForceUpdate = hostedSuppressionsForceUpdate;
    }

    public Boolean isHostedSuppressionsEnabled() {
        return this.hostedSuppressionsEnabled;
    }

    public void setHostedSuppressionsEnabled(Boolean hostedSuppressionsEnabled) {
        this.hostedSuppressionsEnabled = hostedSuppressionsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeWithContextClassloader() throws BuildException {
        this.populateSettings();
        try (Engine engine = new Engine(Update.class.getClassLoader(), this.getSettings());){
            engine.doUpdates();
        }
        catch (UpdateException ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            this.log(ex.getMessage(), 0);
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; unable to update the NVD data";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; unable to update the NVD data", 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setStringIfNotEmpty("proxy.server", this.proxyServer);
        this.getSettings().setStringIfNotEmpty("proxy.port", this.proxyPort);
        this.getSettings().setStringIfNotEmpty("proxy.username", this.proxyUsername);
        this.getSettings().setStringIfNotEmpty("proxy.password", this.proxyPassword);
        this.getSettings().setStringIfNotEmpty("proxy.nonproxyhosts", this.nonProxyHosts);
        this.getSettings().setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.getSettings().setStringIfNotEmpty("connection.read.timeout", this.readTimeout);
        this.getSettings().setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.getSettings().setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.getSettings().setStringIfNotEmpty("data.connection_string", this.connectionString);
        this.getSettings().setStringIfNotEmpty("data.user", this.databaseUser);
        this.getSettings().setStringIfNotEmpty("data.password", this.databasePassword);
        String cveModifiedJson = Optional.ofNullable(this.cveUrlModified).filter(url -> !url.isEmpty()).orElseGet(this::getDefaultCveUrlModified);
        this.getSettings().setStringIfNotEmpty("cve.url.modified", cveModifiedJson);
        this.getSettings().setStringIfNotEmpty("cve.url.base", this.cveUrlBase);
        this.getSettings().setStringIfNotEmpty("cve.download.waittime", this.cveWaitTime);
        this.getSettings().setIntIfNotNull("cve.startyear", this.cveStartYear);
        this.getSettings().setIntIfNotNull("hosted.suppressions.validforhours", this.hostedSuppressionsValidForHours);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.forceupdate", this.hostedSuppressionsForceUpdate);
        this.getSettings().setBooleanIfNotNull("hosted.suppressions.enabled", this.hostedSuppressionsEnabled);
        if (this.cveValidForHours != null) {
            if (this.cveValidForHours >= 0) {
                this.getSettings().setInt("cve.check.validforhours", this.cveValidForHours.intValue());
            } else {
                throw new BuildException("Invalid setting: `cpeValidForHours` must be 0 or greater");
            }
        }
    }

    private String getDefaultCveUrlModified() {
        return CveUrlParser.newInstance((Settings)this.getSettings()).getDefaultCveUrlModified(this.cveUrlBase);
    }
}

