/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.ant.logging;

import org.apache.tools.ant.Task;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class AntLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -8546294566287970709L;
    private transient Task task;

    public AntLoggerAdapter(Task task) {
        this.task = task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        if (this.task != null) {
            this.task.log(msg, 3);
        }
    }

    public void trace(String format, Object arg) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg);
            this.task.log(tp.getMessage(), 3);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.task.log(tp.getMessage(), 3);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arguments);
            this.task.log(tp.getMessage(), 3);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.task != null) {
            this.task.log(msg, t, 3);
        }
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        if (this.task != null) {
            this.task.log(msg, 4);
        }
    }

    public void debug(String format, Object arg) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg);
            this.task.log(tp.getMessage(), 4);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.task.log(tp.getMessage(), 4);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arguments);
            this.task.log(tp.getMessage(), 4);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.task != null) {
            this.task.log(msg, t, 4);
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        if (this.task != null) {
            this.task.log(msg, 2);
        }
    }

    public void info(String format, Object arg) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg);
            this.task.log(tp.getMessage(), 2);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.task.log(tp.getMessage(), 2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arguments);
            this.task.log(tp.getMessage(), 2);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.task != null) {
            this.task.log(msg, t, 2);
        }
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        if (this.task != null) {
            this.task.log(msg, 1);
        }
    }

    public void warn(String format, Object arg) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg);
            this.task.log(tp.getMessage(), 1);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arguments);
            this.task.log(tp.getMessage(), 1);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.task.log(tp.getMessage(), 1);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.task != null) {
            this.task.log(msg, t, 1);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        if (this.task != null) {
            this.task.log(msg, 0);
        }
    }

    public void error(String format, Object arg) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg);
            this.task.log(tp.getMessage(), 0);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.task.log(tp.getMessage(), 0);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.task != null) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arguments);
            this.task.log(tp.getMessage(), 0);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.task != null) {
            this.task.log(msg, t, 0);
        }
    }
}

