/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Purge
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private Settings settings;
    private String dataDirectory = null;
    private boolean failOnError = true;

    public Purge() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.populateSettings();
        try {
            File db = new File(this.getSettings().getDataDirectory(), this.getSettings().getString("data.file_name", "odc.mv.db"));
            if (db.exists()) {
                if (db.delete()) {
                    this.log("Database file purged; local copy of the NVD has been removed", 2);
                } else {
                    String msg = String.format("Unable to delete '%s'; please delete the file manually", db.getAbsolutePath());
                    if (this.failOnError) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
            } else {
                String msg = String.format("Unable to purge database; the database file does not exist: %s", db.getAbsolutePath());
                if (this.failOnError) {
                    throw new BuildException(msg);
                }
                this.log(msg, 0);
            }
        }
        catch (IOException ex) {
            String msg = "Unable to delete the database";
            if (this.failOnError) {
                throw new BuildException("Unable to delete the database");
            }
            this.log("Unable to delete the database", 0);
        }
        finally {
            this.settings.cleanup(true);
        }
    }

    protected void populateSettings() throws BuildException {
        this.settings = new Settings();
        try (InputStream taskProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            this.settings.mergeProperties(taskProperties);
        }
        catch (IOException ex) {
            String msg = "Unable to load the dependency-check ant task.properties file.";
            if (this.failOnError) {
                throw new BuildException("Unable to load the dependency-check ant task.properties file.", (Throwable)ex);
            }
            this.log("Unable to load the dependency-check ant task.properties file.", ex, 1);
        }
        if (this.dataDirectory != null) {
            this.settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(Purge.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
    }
}

