/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import org.apache.tools.ant.BuildException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.taskdefs.Purge;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Update
extends Purge {
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String cveUrl12Modified;
    private String cveUrl12Base;
    private String cveUrl20Base;
    private Integer cveValidForHours;
    private String cveUrl20Modified;

    public Update() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String server) {
        this.proxyServer = server;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getCveUrl12Modified() {
        return this.cveUrl12Modified;
    }

    public void setCveUrl12Modified(String cveUrl12Modified) {
        this.cveUrl12Modified = cveUrl12Modified;
    }

    public String getCveUrl20Modified() {
        return this.cveUrl20Modified;
    }

    public void setCveUrl20Modified(String cveUrl20Modified) {
        this.cveUrl20Modified = cveUrl20Modified;
    }

    public String getCveUrl12Base() {
        return this.cveUrl12Base;
    }

    public void setCveUrl12Base(String cveUrl12Base) {
        this.cveUrl12Base = cveUrl12Base;
    }

    public String getCveUrl20Base() {
        return this.cveUrl20Base;
    }

    public void setCveUrl20Base(String cveUrl20Base) {
        this.cveUrl20Base = cveUrl20Base;
    }

    public Integer getCveValidForHours() {
        return this.cveValidForHours;
    }

    public void setCveValidForHours(Integer cveValidForHours) {
        this.cveValidForHours = cveValidForHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.populateSettings();
        Engine engine = null;
        try {
            engine = new Engine(Update.class.getClassLoader());
            try {
                engine.doUpdates();
            }
            catch (UpdateException ex) {
                if (this.isFailOnError()) {
                    throw new BuildException((Throwable)ex);
                }
                this.log(ex.getMessage(), 0);
            }
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; unable to update the NVD data";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; unable to update the NVD data", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; unable to update the NVD data", 0);
        }
        finally {
            Settings.cleanup((boolean)true);
            if (engine != null) {
                engine.cleanup();
            }
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        Settings.setStringIfNotEmpty((String)"proxy.server", (String)this.proxyServer);
        Settings.setStringIfNotEmpty((String)"proxy.port", (String)this.proxyPort);
        Settings.setStringIfNotEmpty((String)"proxy.username", (String)this.proxyUsername);
        Settings.setStringIfNotEmpty((String)"proxy.password", (String)this.proxyPassword);
        Settings.setStringIfNotEmpty((String)"connection.timeout", (String)this.connectionTimeout);
        Settings.setStringIfNotEmpty((String)"data.driver_name", (String)this.databaseDriverName);
        Settings.setStringIfNotEmpty((String)"data.driver_path", (String)this.databaseDriverPath);
        Settings.setStringIfNotEmpty((String)"data.connection_string", (String)this.connectionString);
        Settings.setStringIfNotEmpty((String)"data.user", (String)this.databaseUser);
        Settings.setStringIfNotEmpty((String)"data.password", (String)this.databasePassword);
        Settings.setStringIfNotEmpty((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        Settings.setStringIfNotEmpty((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        Settings.setStringIfNotEmpty((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        Settings.setStringIfNotEmpty((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        if (this.cveValidForHours != null) {
            if (this.cveValidForHours >= 0) {
                Settings.setInt((String)"cve.check.validforhours", (int)this.cveValidForHours);
            } else {
                throw new BuildException("Invalid setting: `cpeValidForHours` must be 0 or greater");
            }
        }
    }
}

