/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Resources;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.taskdefs.RetirejsFilter;
import org.owasp.dependencycheck.taskdefs.SuppressionFile;
import org.owasp.dependencycheck.taskdefs.Update;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.owasp.dependencycheck.utils.scarf.TelemetryCollector;
import org.slf4j.impl.StaticLoggerBinder;

@NotThreadSafe
public class Check
extends Update {
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private Boolean rubygemsAnalyzerEnabled;
    private Boolean nodeAnalyzerEnabled;
    private Boolean nodeAuditAnalyzerEnabled;
    private Boolean yarnAuditAnalyzerEnabled;
    private Boolean pnpmAuditAnalyzerEnabled;
    private Boolean nodeAuditAnalyzerUseCache;
    private Boolean nodePackageSkipDevDependencies;
    private Boolean nodeAuditSkipDevDependencies;
    private final List<String> retirejsFilters = new ArrayList<String>();
    private Boolean retirejsFilterNonVulnerable;
    private Boolean bundleAuditAnalyzerEnabled;
    private Boolean cmakeAnalyzerEnabled;
    private Boolean opensslAnalyzerEnabled;
    private Boolean pyPackageAnalyzerEnabled;
    private Boolean pyDistributionAnalyzerEnabled;
    private Boolean mixAuditAnalyzerEnabled;
    private Boolean centralAnalyzerEnabled;
    private Boolean centralAnalyzerUseCache;
    private Boolean nexusAnalyzerEnabled;
    private String nexusUrl;
    private String nexusUser;
    private String nexusPassword;
    private Boolean nexusUsesProxy;
    private Boolean golangDepEnabled;
    private Boolean golangModEnabled;
    private String pathToGo;
    private Boolean dartAnalyzerEnabled;
    private String pathToYarn;
    private String pathToPnpm;
    private String zipExtensions;
    private String pathToCore;
    private String projectName = "dependency-check";
    private String reportOutputDirectory;
    private float junitFailOnCVSS = 0.0f;
    private float failBuildOnCVSS = 11.0f;
    private Boolean autoUpdate;
    private String reportFormat = "HTML";
    private final List<String> reportFormats = new ArrayList<String>();
    private Boolean prettyPrint = null;
    private final List<String> suppressionFiles = new ArrayList<String>();
    private String hintsFile;
    private boolean showSummary = true;
    private Boolean enableExperimental;
    private Boolean enableRetired;
    private Boolean jarAnalyzerEnabled;
    private Boolean archiveAnalyzerEnabled;
    private Boolean nuspecAnalyzerEnabled;
    private Boolean nugetconfAnalyzerEnabled;
    private Boolean libmanAnalyzerEnabled;
    private Boolean composerAnalyzerEnabled;
    private Boolean composerAnalyzerSkipDev;
    private Boolean cpanfileAnalyzerEnabled;
    private Boolean assemblyAnalyzerEnabled;
    private Boolean msbuildAnalyzerEnabled;
    private Boolean autoconfAnalyzerEnabled;
    private Boolean pipAnalyzerEnabled;
    private Boolean mavenInstallAnalyzerEnabled;
    private Boolean pipfileAnalyzerEnabled;
    private Boolean poetryAnalyzerEnabled;
    private String mixAuditPath;
    private String bundleAuditPath;
    private String bundleAuditWorkingDirectory;
    private Boolean cocoapodsAnalyzerEnabled;
    private Boolean carthageAnalyzerEnabled;
    private Boolean swiftPackageManagerAnalyzerEnabled;
    private Boolean swiftPackageResolvedAnalyzerEnabled;
    private Boolean ossindexAnalyzerEnabled;
    private Boolean ossindexAnalyzerUseCache;
    private String ossindexAnalyzerUrl;
    private String ossindexAnalyzerUsername;
    private String ossindexAnalyzerPassword;
    private Boolean ossIndexAnalyzerWarnOnlyOnRemoteErrors;
    private Boolean artifactoryAnalyzerEnabled;
    private String artifactoryAnalyzerUrl;
    private Boolean artifactoryAnalyzerUseProxy;
    private Boolean artifactoryAnalyzerParallelAnalysis;
    private String artifactoryAnalyzerUsername;
    private String artifactoryAnalyzerApiToken;
    private String artifactoryAnalyzerBearerToken;
    private Boolean versionCheckEnabled;
    private boolean failBuildOnUnusedSuppressionRule = false;
    private String suppressionFileUser;
    private String suppressionFilePassword;
    private String suppressionFileBearerToken;
    private Resources path = null;
    private Reference refId = null;

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw new BuildException("Nested elements are not allowed when using the refId attribute.");
        }
        this.getPath().add(rc);
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public boolean isReference() {
        return this.refId != null;
    }

    public synchronized void setRefId(Reference r) {
        if (this.path != null) {
            throw new BuildException("Nested elements are not allowed when using the refId attribute.");
        }
        this.refId = r;
    }

    private void dealWithReferences() throws BuildException {
        if (this.isReference()) {
            Object o = this.refId.getReferencedObject(this.getProject());
            if (!(o instanceof ResourceCollection)) {
                throw new BuildException("refId '" + this.refId.getRefId() + "' does not refer to a resource collection.");
            }
            this.getPath().add((ResourceCollection)o);
        }
    }

    public Check() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public void addConfiguredSuppressionFile(SuppressionFile suppressionFile) {
        this.suppressionFiles.add(this.resolveRelative(suppressionFile.getPath()));
    }

    public void addConfiguredReportFormat(ReportFormat reportFormat) {
        this.reportFormats.add(reportFormat.getFormat());
    }

    public void setVersionCheckEnabled(Boolean versionCheckEnabled) {
        this.versionCheckEnabled = versionCheckEnabled;
    }

    public String getProjectName() {
        if (this.projectName == null) {
            this.projectName = "";
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private String resolveRelative(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return path;
        }
        return new File(this.getProject().getBaseDir(), path).getPath();
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = this.resolveRelative(reportOutputDirectory);
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public void setJunitFailOnCVSS(float junitFailOnCVSS) {
        this.junitFailOnCVSS = junitFailOnCVSS;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setReportFormat(ReportFormats reportFormat) {
        this.reportFormat = reportFormat.getValue();
        this.reportFormats.add(this.reportFormat);
    }

    public List<String> getReportFormats() {
        if (this.reportFormats.isEmpty()) {
            this.reportFormats.add(this.reportFormat);
        }
        return this.reportFormats;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFiles.add(this.resolveRelative(suppressionFile));
    }

    public void setSuppressionFileUser(String suppressionFileUser) {
        this.suppressionFileUser = suppressionFileUser;
    }

    public void setSuppressionFilePassword(String suppressionFilePassword) {
        this.suppressionFilePassword = suppressionFilePassword;
    }

    public void setSuppressionFileBearerToken(String suppressionFileBearerToken) {
        this.suppressionFileBearerToken = suppressionFileBearerToken;
    }

    public void setHintsFile(String hintsFile) {
        this.hintsFile = hintsFile;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public void setEnableExperimental(Boolean enableExperimental) {
        this.enableExperimental = enableExperimental;
    }

    public void setEnableRetired(Boolean enableRetired) {
        this.enableRetired = enableRetired;
    }

    public void setJarAnalyzerEnabled(Boolean jarAnalyzerEnabled) {
        this.jarAnalyzerEnabled = jarAnalyzerEnabled;
    }

    public void setArchiveAnalyzerEnabled(Boolean archiveAnalyzerEnabled) {
        this.archiveAnalyzerEnabled = archiveAnalyzerEnabled;
    }

    public void setAssemblyAnalyzerEnabled(Boolean assemblyAnalyzerEnabled) {
        this.assemblyAnalyzerEnabled = assemblyAnalyzerEnabled;
    }

    public void setMSBuildAnalyzerEnabled(Boolean msbuildAnalyzerEnabled) {
        this.msbuildAnalyzerEnabled = msbuildAnalyzerEnabled;
    }

    public void setNuspecAnalyzerEnabled(Boolean nuspecAnalyzerEnabled) {
        this.nuspecAnalyzerEnabled = nuspecAnalyzerEnabled;
    }

    public void setNugetconfAnalyzerEnabled(Boolean nugetconfAnalyzerEnabled) {
        this.nugetconfAnalyzerEnabled = nugetconfAnalyzerEnabled;
    }

    public void setLibmanAnalyzerEnabled(Boolean libmanAnalyzerEnabled) {
        this.libmanAnalyzerEnabled = libmanAnalyzerEnabled;
    }

    public void setComposerAnalyzerEnabled(Boolean composerAnalyzerEnabled) {
        this.composerAnalyzerEnabled = composerAnalyzerEnabled;
    }

    public void setComposerAnalyzerSkipDev(Boolean composerAnalyzerSkipDev) {
        this.composerAnalyzerSkipDev = composerAnalyzerSkipDev;
    }

    public void setCpanfileAnalyzerEnabled(Boolean cpanfileAnalyzerEnabled) {
        this.cpanfileAnalyzerEnabled = cpanfileAnalyzerEnabled;
    }

    public void setAutoconfAnalyzerEnabled(Boolean autoconfAnalyzerEnabled) {
        this.autoconfAnalyzerEnabled = autoconfAnalyzerEnabled;
    }

    public void setPipAnalyzerEnabled(Boolean pipAnalyzerEnabled) {
        this.pipAnalyzerEnabled = pipAnalyzerEnabled;
    }

    public void setPipfileAnalyzerEnabled(Boolean pipfileAnalyzerEnabled) {
        this.pipfileAnalyzerEnabled = pipfileAnalyzerEnabled;
    }

    public void setPoetryAnalyzerEnabled(Boolean poetryAnalyzerEnabled) {
        this.poetryAnalyzerEnabled = poetryAnalyzerEnabled;
    }

    public void setBundleAuditAnalyzerEnabled(Boolean bundleAuditAnalyzerEnabled) {
        this.bundleAuditAnalyzerEnabled = bundleAuditAnalyzerEnabled;
    }

    public void setBundleAuditPath(String bundleAuditPath) {
        this.bundleAuditPath = bundleAuditPath;
    }

    public void setBundleAuditWorkingDirectory(String bundleAuditWorkingDirectory) {
        this.bundleAuditWorkingDirectory = bundleAuditWorkingDirectory;
    }

    public void setCocoapodsAnalyzerEnabled(Boolean cocoapodsAnalyzerEnabled) {
        this.cocoapodsAnalyzerEnabled = cocoapodsAnalyzerEnabled;
    }

    public void setCarthageAnalyzerEnabled(Boolean carthageAnalyzerEnabled) {
        this.carthageAnalyzerEnabled = carthageAnalyzerEnabled;
    }

    public void setSwiftPackageManagerAnalyzerEnabled(Boolean swiftPackageManagerAnalyzerEnabled) {
        this.swiftPackageManagerAnalyzerEnabled = swiftPackageManagerAnalyzerEnabled;
    }

    public void setSwiftPackageResolvedAnalyzerEnabled(Boolean swiftPackageResolvedAnalyzerEnabled) {
        this.swiftPackageResolvedAnalyzerEnabled = swiftPackageResolvedAnalyzerEnabled;
    }

    public void setOpensslAnalyzerEnabled(Boolean opensslAnalyzerEnabled) {
        this.opensslAnalyzerEnabled = opensslAnalyzerEnabled;
    }

    public void setNodeAnalyzerEnabled(Boolean nodeAnalyzerEnabled) {
        this.nodeAnalyzerEnabled = nodeAnalyzerEnabled;
    }

    public void setNodeAuditAnalyzerEnabled(Boolean nodeAuditAnalyzerEnabled) {
        this.nodeAuditAnalyzerEnabled = nodeAuditAnalyzerEnabled;
    }

    public void setYarnAuditAnalyzerEnabled(Boolean yarnAuditAnalyzerEnabled) {
        this.yarnAuditAnalyzerEnabled = yarnAuditAnalyzerEnabled;
    }

    public void setPnpmAuditAnalyzerEnabled(Boolean pnpmAuditAnalyzerEnabled) {
        this.pnpmAuditAnalyzerEnabled = pnpmAuditAnalyzerEnabled;
    }

    public void setNodeAuditAnalyzerUseCache(Boolean nodeAuditAnalyzerUseCache) {
        this.nodeAuditAnalyzerUseCache = nodeAuditAnalyzerUseCache;
    }

    public void setNodePackageSkipDevDependencies(Boolean nodePackageSkipDevDependencies) {
        this.nodePackageSkipDevDependencies = nodePackageSkipDevDependencies;
    }

    public void setNodeAuditSkipDevDependencies(Boolean nodeAuditSkipDevDependencies) {
        this.nodeAuditSkipDevDependencies = nodeAuditSkipDevDependencies;
    }

    public void setRetirejsFilterNonVulnerable(Boolean retirejsFilterNonVulnerable) {
        this.retirejsFilterNonVulnerable = retirejsFilterNonVulnerable;
    }

    public void addConfiguredRetirejsFilter(RetirejsFilter retirejsFilter) {
        this.retirejsFilters.add(retirejsFilter.getRegex());
    }

    public void setRubygemsAnalyzerEnabled(Boolean rubygemsAnalyzerEnabled) {
        this.rubygemsAnalyzerEnabled = rubygemsAnalyzerEnabled;
    }

    public void setPyPackageAnalyzerEnabled(Boolean pyPackageAnalyzerEnabled) {
        this.pyPackageAnalyzerEnabled = pyPackageAnalyzerEnabled;
    }

    public void setPyDistributionAnalyzerEnabled(Boolean pyDistributionAnalyzerEnabled) {
        this.pyDistributionAnalyzerEnabled = pyDistributionAnalyzerEnabled;
    }

    public void setMixAuditAnalyzerEnabled(Boolean mixAuditAnalyzerEnabled) {
        this.mixAuditAnalyzerEnabled = mixAuditAnalyzerEnabled;
    }

    public void setMixAuditPath(String mixAuditPath) {
        this.mixAuditPath = mixAuditPath;
    }

    public void setCentralAnalyzerEnabled(Boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerUseCache(Boolean centralAnalyzerUseCache) {
        this.centralAnalyzerUseCache = centralAnalyzerUseCache;
    }

    public void setNexusAnalyzerEnabled(Boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public void setGolangDepEnabled(Boolean golangDepEnabled) {
        this.golangDepEnabled = golangDepEnabled;
    }

    public void setGolangModEnabled(Boolean golangModEnabled) {
        this.golangModEnabled = golangModEnabled;
    }

    public void setDartAnalyzerEnabled(Boolean dartAnalyzerEnabled) {
        this.dartAnalyzerEnabled = dartAnalyzerEnabled;
    }

    public void setPathToYarn(String pathToYarn) {
        this.pathToYarn = pathToYarn;
    }

    public void setPathToPnpm(String pathToPnpm) {
        this.pathToPnpm = pathToPnpm;
    }

    public void setPathToGo(String pathToGo) {
        this.pathToGo = pathToGo;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public void setNexusUser(String nexusUser) {
        this.nexusUser = nexusUser;
    }

    public void setNexusPassword(String nexusPassword) {
        this.nexusPassword = nexusPassword;
    }

    public void setNexusUsesProxy(Boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public void setPathToDotnetCore(String pathToCore) {
        this.pathToCore = pathToCore;
    }

    public void setOssindexAnalyzerEnabled(Boolean ossindexAnalyzerEnabled) {
        this.ossindexAnalyzerEnabled = ossindexAnalyzerEnabled;
    }

    public void setOssindexAnalyzerUseCache(Boolean ossindexAnalyzerUseCache) {
        this.ossindexAnalyzerUseCache = ossindexAnalyzerUseCache;
    }

    public void setOssindexAnalyzerUrl(String ossindexAnalyzerUrl) {
        this.ossindexAnalyzerUrl = ossindexAnalyzerUrl;
    }

    public void setOssindexAnalyzerUsername(String ossindexAnalyzerUsername) {
        this.ossindexAnalyzerUsername = ossindexAnalyzerUsername;
    }

    public void setOssindexAnalyzerPassword(String ossindexAnalyzerPassword) {
        this.ossindexAnalyzerPassword = ossindexAnalyzerPassword;
    }

    public void setOssIndexWarnOnlyOnRemoteErrors(Boolean ossIndexWarnOnlyOnRemoteErrors) {
        this.ossIndexAnalyzerWarnOnlyOnRemoteErrors = ossIndexWarnOnlyOnRemoteErrors;
    }

    public void setCmakeAnalyzerEnabled(Boolean cmakeAnalyzerEnabled) {
        this.cmakeAnalyzerEnabled = cmakeAnalyzerEnabled;
    }

    public void setArtifactoryAnalyzerEnabled(Boolean artifactoryAnalyzerEnabled) {
        this.artifactoryAnalyzerEnabled = artifactoryAnalyzerEnabled;
    }

    public void setArtifactoryAnalyzerUrl(String artifactoryAnalyzerUrl) {
        this.artifactoryAnalyzerUrl = artifactoryAnalyzerUrl;
    }

    public void setArtifactoryAnalyzerUseProxy(Boolean artifactoryAnalyzerUseProxy) {
        this.artifactoryAnalyzerUseProxy = artifactoryAnalyzerUseProxy;
    }

    public void setArtifactoryAnalyzerParallelAnalysis(Boolean artifactoryAnalyzerParallelAnalysis) {
        this.artifactoryAnalyzerParallelAnalysis = artifactoryAnalyzerParallelAnalysis;
    }

    public void setArtifactoryAnalyzerUsername(String artifactoryAnalyzerUsername) {
        this.artifactoryAnalyzerUsername = artifactoryAnalyzerUsername;
    }

    public void setArtifactoryAnalyzerApiToken(String artifactoryAnalyzerApiToken) {
        this.artifactoryAnalyzerApiToken = artifactoryAnalyzerApiToken;
    }

    public void setArtifactoryAnalyzerBearerToken(String artifactoryAnalyzerBearerToken) {
        this.artifactoryAnalyzerBearerToken = artifactoryAnalyzerBearerToken;
    }

    public void setFailBuildOnUnusedSuppressionRule(boolean failBuildOnUnusedSuppressionRule) {
        this.failBuildOnUnusedSuppressionRule = failBuildOnUnusedSuppressionRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeWithContextClassloader() throws BuildException {
        this.dealWithReferences();
        this.validateConfiguration();
        this.populateSettings();
        try {
            Downloader.getInstance().configure(this.getSettings());
        }
        catch (InvalidSettingException e) {
            throw new BuildException((Throwable)e);
        }
        TelemetryCollector.send((Settings)this.getSettings());
        try (Engine engine = new Engine(Check.class.getClassLoader(), this.getSettings());){
            for (Resource resource : this.getPath()) {
                File file;
                FileProvider provider = (FileProvider)resource.as(FileProvider.class);
                if (provider == null || (file = provider.getFile()) == null || !file.exists()) continue;
                engine.scan(file);
            }
            ExceptionCollection exceptions = this.callExecuteAnalysis(engine);
            if (exceptions == null || !exceptions.isFatal()) {
                for (String format : this.getReportFormats()) {
                    engine.writeReports(this.getProjectName(), new File(this.reportOutputDirectory), format, exceptions);
                }
                if (this.failBuildOnCVSS <= 10.0f) {
                    this.checkForFailure(engine.getDependencies());
                }
                if (this.showSummary) {
                    DependencyCheckScanAgent.showSummary((Dependency[])engine.getDependencies());
                }
            }
        }
        catch (DatabaseException ex) {
            String msg = "Unable to connect to the dependency-check database; analysis has stopped";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to connect to the dependency-check database; analysis has stopped", (Throwable)ex);
            }
            this.log("Unable to connect to the dependency-check database; analysis has stopped", ex, 0);
        }
        catch (ReportException ex) {
            String msg = "Unable to generate the dependency-check report";
            if (this.isFailOnError()) {
                throw new BuildException("Unable to generate the dependency-check report", (Throwable)ex);
            }
            this.log("Unable to generate the dependency-check report", ex, 0);
        }
        finally {
            this.getSettings().cleanup();
        }
    }

    private ExceptionCollection callExecuteAnalysis(Engine engine) throws BuildException {
        ExceptionCollection exceptions = null;
        try {
            engine.analyzeDependencies();
        }
        catch (ExceptionCollection ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            exceptions = ex;
        }
        return exceptions;
    }

    private synchronized void validateConfiguration() throws BuildException {
        if (this.path == null) {
            throw new BuildException("No project dependencies have been defined to analyze.");
        }
        if (this.failBuildOnCVSS < 0.0f || this.failBuildOnCVSS > 11.0f) {
            throw new BuildException("Invalid configuration, failBuildOnCVSS must be between 0 and 11.");
        }
    }

    @Override
    protected void populateSettings() throws BuildException {
        super.populateSettings();
        this.getSettings().setBooleanIfNotNull("odc.autoupdate", this.autoUpdate);
        this.getSettings().setArrayIfNotEmpty("suppression.file", this.suppressionFiles);
        this.getSettings().setStringIfNotEmpty("suppression.file.user", this.suppressionFileUser);
        this.getSettings().setStringIfNotEmpty("suppression.file.password", this.suppressionFilePassword);
        this.getSettings().setStringIfNotEmpty("suppression.file.bearertoken", this.suppressionFileBearerToken);
        this.getSettings().setBooleanIfNotNull("updater.versioncheck.enabled", this.versionCheckEnabled);
        this.getSettings().setStringIfNotEmpty("hints.file", this.hintsFile);
        this.getSettings().setBooleanIfNotNull("analyzer.experimental.enabled", this.enableExperimental);
        this.getSettings().setBooleanIfNotNull("odc.reports.pretty.print", this.prettyPrint);
        this.getSettings().setBooleanIfNotNull("analyzer.retired.enabled", this.enableRetired);
        this.getSettings().setBooleanIfNotNull("analyzer.jar.enabled", this.jarAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.python.distribution.enabled", this.pyDistributionAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.python.package.enabled", this.pyPackageAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.ruby.gemspec.enabled", this.rubygemsAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.openssl.enabled", this.opensslAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.cmake.enabled", this.cmakeAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.enabled", this.artifactoryAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.url", this.artifactoryAnalyzerUrl);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.proxy", this.artifactoryAnalyzerUseProxy);
        this.getSettings().setBooleanIfNotNull("analyzer.artifactory.parallel.analysis", this.artifactoryAnalyzerParallelAnalysis);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.api.username", this.artifactoryAnalyzerUsername);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.api.token", this.artifactoryAnalyzerApiToken);
        this.getSettings().setStringIfNotEmpty("analyzer.artifactory.bearer.token", this.artifactoryAnalyzerBearerToken);
        this.getSettings().setBooleanIfNotNull("analyzer.swift.package.manager.enabled", this.swiftPackageManagerAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.swift.package.resolved.enabled", this.swiftPackageResolvedAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.cocoapods.enabled", this.cocoapodsAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.carthage.enabled", this.carthageAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.bundle.audit.enabled", this.bundleAuditAnalyzerEnabled);
        this.getSettings().setStringIfNotNull("analyzer.bundle.audit.path", this.bundleAuditPath);
        this.getSettings().setStringIfNotNull("analyzer.bundle.audit.working.directory", this.bundleAuditWorkingDirectory);
        this.getSettings().setBooleanIfNotNull("analyzer.autoconf.enabled", this.autoconfAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.maveninstall.enabled", this.mavenInstallAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.pip.enabled", this.pipAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.pipfile.enabled", this.pipfileAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.poetry.enabled", this.poetryAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.composer.lock.enabled", this.composerAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.composer.lock.skipdev", this.composerAnalyzerSkipDev);
        this.getSettings().setBooleanIfNotNull("analyzer.cpanfile.enabled", this.cpanfileAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.node.package.enabled", this.nodeAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.node.package.skipdev", this.nodePackageSkipDevDependencies);
        this.getSettings().setBooleanIfNotNull("analyzer.node.audit.enabled", this.nodeAuditAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.yarn.audit.enabled", this.yarnAuditAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.pnpm.audit.enabled", this.pnpmAuditAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.node.audit.use.cache", this.nodeAuditAnalyzerUseCache);
        this.getSettings().setBooleanIfNotNull("analyzer.node.audit.skipdev", this.nodeAuditSkipDevDependencies);
        this.getSettings().setBooleanIfNotNull("analyzer.retirejs.filternonvulnerable", this.retirejsFilterNonVulnerable);
        this.getSettings().setArrayIfNotEmpty("analyzer.retirejs.filters", this.retirejsFilters);
        this.getSettings().setBooleanIfNotNull("analyzer.golang.dep.enabled", this.golangDepEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.golang.mod.enabled", this.golangModEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.dart.enabled", this.dartAnalyzerEnabled);
        this.getSettings().setStringIfNotNull("analyzer.golang.path", this.pathToGo);
        this.getSettings().setStringIfNotNull("analyzer.yarn.path", this.pathToYarn);
        this.getSettings().setStringIfNotNull("analyzer.pnpm.path", this.pathToPnpm);
        this.getSettings().setBooleanIfNotNull("analyzer.mix.audit.enabled", this.mixAuditAnalyzerEnabled);
        this.getSettings().setStringIfNotNull("analyzer.mix.audit.path", this.mixAuditPath);
        this.getSettings().setBooleanIfNotNull("analyzer.nuspec.enabled", this.nuspecAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.nugetconf.enabled", this.nugetconfAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.libman.enabled", this.libmanAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.central.enabled", this.centralAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.central.use.cache", this.centralAnalyzerUseCache);
        this.getSettings().setBooleanIfNotNull("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.archive.enabled", this.archiveAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.assembly.enabled", this.assemblyAnalyzerEnabled);
        this.getSettings().setBooleanIfNotNull("analyzer.msbuildproject.enabled", this.msbuildAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.url", this.nexusUrl);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.username", this.nexusUser);
        this.getSettings().setStringIfNotEmpty("analyzer.nexus.password", this.nexusPassword);
        this.getSettings().setBooleanIfNotNull("analyzer.nexus.proxy", this.nexusUsesProxy);
        this.getSettings().setStringIfNotEmpty("extensions.zip", this.zipExtensions);
        this.getSettings().setStringIfNotEmpty("analyzer.assembly.dotnet.path", this.pathToCore);
        this.getSettings().setBooleanIfNotNull("analyzer.ossindex.enabled", this.ossindexAnalyzerEnabled);
        this.getSettings().setStringIfNotEmpty("analyzer.ossindex.url", this.ossindexAnalyzerUrl);
        this.getSettings().setStringIfNotEmpty("analyzer.ossindex.user", this.ossindexAnalyzerUsername);
        this.getSettings().setStringIfNotEmpty("analyzer.ossindex.password", this.ossindexAnalyzerPassword);
        this.getSettings().setBooleanIfNotNull("analyzer.ossindex.use.cache", this.ossindexAnalyzerUseCache);
        this.getSettings().setBooleanIfNotNull("analyzer.ossindex.remote-error.warn-only", this.ossIndexAnalyzerWarnOnlyOnRemoteErrors);
        this.getSettings().setFloat("junit.fail.on.cvss", this.junitFailOnCVSS);
        this.getSettings().setBooleanIfNotNull("analyzer.suppression.unused.fail", Boolean.valueOf(this.failBuildOnUnusedSuppressionRule));
    }

    private void checkForFailure(Dependency[] dependencies) throws BuildException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                double unscoredCvss;
                double cvssV2 = v.getCvssV2() != null && v.getCvssV2().getCvssData() != null && v.getCvssV2().getCvssData().getBaseScore() != null ? v.getCvssV2().getCvssData().getBaseScore() : -1.0;
                double cvssV3 = v.getCvssV3() != null && v.getCvssV3().getCvssData() != null && v.getCvssV3().getCvssData().getBaseScore() != null ? v.getCvssV3().getCvssData().getBaseScore() : -1.0;
                double cvssV4 = v.getCvssV4() != null && v.getCvssV4().getCvssData() != null && v.getCvssV4().getCvssData().getBaseScore() != null ? v.getCvssV4().getCvssData().getBaseScore() : -1.0;
                boolean useUnscored = cvssV2 == -1.0 && cvssV3 == -1.0 && cvssV4 == -1.0;
                double d2 = unscoredCvss = useUnscored && v.getUnscoredSeverity() != null ? SeverityUtil.estimateCvssV2((String)v.getUnscoredSeverity()) : -1.0;
                if (!(cvssV2 >= (double)this.failBuildOnCVSS || cvssV3 >= (double)this.failBuildOnCVSS || cvssV4 >= (double)this.failBuildOnCVSS || unscoredCvss >= (double)this.failBuildOnCVSS) && !(this.failBuildOnCVSS <= 0.0f)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(" (").append(Stream.concat(d.getSoftwareIdentifiers().stream(), d.getVulnerableSoftwareIdentifiers().stream()).map(Identifier::getValue).collect(Collectors.joining(", "))).append("): ").append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.showSummary ? String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids) : String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities.%n%nSee the dependency-check report for more details.%n%n", new Object[0]);
            throw new BuildException(msg);
        }
    }

    public static class ReportFormat {
        private ReportFormats format;

        public String getFormat() {
            return this.format.getValue();
        }

        public void setFormat(String format) {
            this.format = (ReportFormats)EnumeratedAttribute.getInstance(ReportFormats.class, (String)format);
        }
    }

    public static class ReportFormats
    extends EnumeratedAttribute {
        public String[] getValues() {
            int i = 0;
            ReportGenerator.Format[] formats = ReportGenerator.Format.values();
            String[] values = new String[formats.length];
            for (ReportGenerator.Format format : formats) {
                values[i++] = format.name();
            }
            return values;
        }
    }
}

