/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import io.github.jeremylong.jcs3.slf4j.Slf4jAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Purge
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private Settings settings;
    private String dataDirectory = null;
    private boolean failOnError = true;

    public Purge() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public final void execute() throws BuildException {
        this.muteNoisyLoggers();
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.executeWithContextClassloader();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private void muteNoisyLoggers() {
        String[] noisyLoggers;
        System.setProperty("jcs.logSystem", "slf4j");
        Slf4jAdapter.muteLogging((boolean)true);
        for (String loggerName : noisyLoggers = new String[]{"org.apache.hc"}) {
            System.setProperty("org.slf4j.simpleLogger.log." + loggerName, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWithContextClassloader() throws BuildException {
        this.populateSettings();
        try {
            Downloader.getInstance().configure(this.settings);
        }
        catch (InvalidSettingException e) {
            throw new BuildException((Throwable)e);
        }
        try (Engine engine = new Engine(Engine.Mode.EVIDENCE_PROCESSING, this.getSettings());){
            engine.purge();
        }
        finally {
            this.settings.cleanup(true);
        }
    }

    protected void populateSettings() throws BuildException {
        this.settings = new Settings();
        try (InputStream taskProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            this.settings.mergeProperties(taskProperties);
        }
        catch (IOException ex) {
            String msg = "Unable to load the dependency-check ant task.properties file.";
            if (this.failOnError) {
                throw new BuildException("Unable to load the dependency-check ant task.properties file.", (Throwable)ex);
            }
            this.log("Unable to load the dependency-check ant task.properties file.", ex, 1);
        }
        if (this.dataDirectory != null) {
            this.settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(Purge.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
    }
}

