/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Resources;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.taskdefs.Update;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Check
extends Update {
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private Resources path = null;
    private Reference refid = null;
    @Deprecated
    private String applicationName = null;
    private String projectName = "dependency-check";
    private String reportOutputDirectory = ".";
    private float failBuildOnCVSS = 11.0f;
    private boolean autoUpdate = true;
    private boolean updateOnly = false;
    private String reportFormat = "HTML";
    private String suppressionFile;
    private boolean showSummary = true;
    private boolean jarAnalyzerEnabled = true;
    private boolean archiveAnalyzerEnabled = true;
    private boolean assemblyAnalyzerEnabled = true;
    private boolean nuspecAnalyzerEnabled = true;
    private boolean composerAnalyzerEnabled = true;
    private boolean autoconfAnalyzerEnabled = true;
    private boolean cmakeAnalyzerEnabled = true;
    private boolean opensslAnalyzerEnabled = true;
    private boolean nodeAnalyzerEnabled = true;
    private boolean rubygemsAnalyzerEnabled = true;
    private boolean pyPackageAnalyzerEnabled = true;
    private boolean pyDistributionAnalyzerEnabled = true;
    private boolean centralAnalyzerEnabled = false;
    private boolean nexusAnalyzerEnabled = true;
    private String nexusUrl;
    private boolean nexusUsesProxy = true;
    private String zipExtensions;
    private String pathToMono;

    public Check() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.getPath().add(rc);
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.refid = r;
    }

    private void dealWithReferences() throws BuildException {
        if (this.isReference()) {
            Object o = this.refid.getReferencedObject(this.getProject());
            if (!(o instanceof ResourceCollection)) {
                throw new BuildException("refid '" + this.refid.getRefId() + "' does not refer to a resource collection.");
            }
            this.getPath().add((ResourceCollection)o);
        }
    }

    @Deprecated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getProjectName() {
        if (this.applicationName != null) {
            this.log("Configuration 'applicationName' has been deprecated, please use 'projectName' instead", 1);
            if ("dependency-check".equals(this.projectName)) {
                this.projectName = this.applicationName;
            }
        }
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isUpdateOnly() {
        return this.updateOnly;
    }

    public void setUpdateOnly(boolean updateOnly) {
        this.updateOnly = updateOnly;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormats reportFormat) {
        this.reportFormat = reportFormat.getValue();
    }

    public String getSuppressionFile() {
        return this.suppressionFile;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public boolean isJarAnalyzerEnabled() {
        return this.jarAnalyzerEnabled;
    }

    public void setJarAnalyzerEnabled(boolean jarAnalyzerEnabled) {
        this.jarAnalyzerEnabled = jarAnalyzerEnabled;
    }

    public boolean isArchiveAnalyzerEnabled() {
        return this.archiveAnalyzerEnabled;
    }

    public void setArchiveAnalyzerEnabled(boolean archiveAnalyzerEnabled) {
        this.archiveAnalyzerEnabled = archiveAnalyzerEnabled;
    }

    public boolean isAssemblyAnalyzerEnabled() {
        return this.assemblyAnalyzerEnabled;
    }

    public void setAssemblyAnalyzerEnabled(boolean assemblyAnalyzerEnabled) {
        this.assemblyAnalyzerEnabled = assemblyAnalyzerEnabled;
    }

    public boolean isNuspecAnalyzerEnabled() {
        return this.nuspecAnalyzerEnabled;
    }

    public void setNuspecAnalyzerEnabled(boolean nuspecAnalyzerEnabled) {
        this.nuspecAnalyzerEnabled = nuspecAnalyzerEnabled;
    }

    public boolean isComposerAnalyzerEnabled() {
        return this.composerAnalyzerEnabled;
    }

    public void setComposerAnalyzerEnabled(boolean composerAnalyzerEnabled) {
        this.composerAnalyzerEnabled = composerAnalyzerEnabled;
    }

    public boolean isAutoconfAnalyzerEnabled() {
        return this.autoconfAnalyzerEnabled;
    }

    public void setAutoconfAnalyzerEnabled(boolean autoconfAnalyzerEnabled) {
        this.autoconfAnalyzerEnabled = autoconfAnalyzerEnabled;
    }

    public boolean isCMakeAnalyzerEnabled() {
        return this.cmakeAnalyzerEnabled;
    }

    public void setCMakeAnalyzerEnabled(boolean cmakeAnalyzerEnabled) {
        this.cmakeAnalyzerEnabled = cmakeAnalyzerEnabled;
    }

    public boolean isOpensslAnalyzerEnabled() {
        return this.opensslAnalyzerEnabled;
    }

    public void setOpensslAnalyzerEnabled(boolean opensslAnalyzerEnabled) {
        this.opensslAnalyzerEnabled = opensslAnalyzerEnabled;
    }

    public boolean isNodeAnalyzerEnabled() {
        return this.nodeAnalyzerEnabled;
    }

    public void setNodeAnalyzerEnabled(boolean nodeAnalyzerEnabled) {
        this.nodeAnalyzerEnabled = nodeAnalyzerEnabled;
    }

    public boolean isRubygemsAnalyzerEnabled() {
        return this.rubygemsAnalyzerEnabled;
    }

    public void setRubygemsAnalyzerEnabled(boolean rubygemsAnalyzerEnabled) {
        this.rubygemsAnalyzerEnabled = rubygemsAnalyzerEnabled;
    }

    public boolean isPyPackageAnalyzerEnabled() {
        return this.pyPackageAnalyzerEnabled;
    }

    public void setPyPackageAnalyzerEnabled(boolean pyPackageAnalyzerEnabled) {
        this.pyPackageAnalyzerEnabled = pyPackageAnalyzerEnabled;
    }

    public boolean isPyDistributionAnalyzerEnabled() {
        return this.pyDistributionAnalyzerEnabled;
    }

    public void setPyDistributionAnalyzerEnabled(boolean pyDistributionAnalyzerEnabled) {
        this.pyDistributionAnalyzerEnabled = pyDistributionAnalyzerEnabled;
    }

    public boolean isCentralAnalyzerEnabled() {
        return this.centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerEnabled(boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getPathToMono() {
        return this.pathToMono;
    }

    public void setPathToMono(String pathToMono) {
        this.pathToMono = pathToMono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        block19: {
            this.dealWithReferences();
            this.validateConfiguration();
            this.populateSettings();
            Engine engine = null;
            try {
                engine = new Engine(Check.class.getClassLoader());
                if (this.isUpdateOnly()) {
                    this.log("Deprecated 'UpdateOnly' property set; please use the UpdateTask instead", 1);
                    engine.doUpdates();
                    break block19;
                }
                try {
                    for (Resource resource : this.path) {
                        File file;
                        FileProvider provider = (FileProvider)resource.as(FileProvider.class);
                        if (provider == null || (file = provider.getFile()) == null || !file.exists()) continue;
                        engine.scan(file);
                    }
                    engine.analyzeDependencies();
                    DatabaseProperties prop = null;
                    CveDB cve = null;
                    try {
                        cve = new CveDB();
                        cve.open();
                        prop = cve.getDatabaseProperties();
                    }
                    catch (DatabaseException ex) {
                        this.log("Unable to retrieve DB Properties", ex, 4);
                    }
                    finally {
                        if (cve != null) {
                            cve.close();
                        }
                    }
                    ReportGenerator reporter = new ReportGenerator(this.getProjectName(), engine.getDependencies(), engine.getAnalyzers(), prop);
                    reporter.generateReports(this.reportOutputDirectory, this.reportFormat);
                    if (this.failBuildOnCVSS <= 10.0f) {
                        this.checkForFailure(engine.getDependencies());
                    }
                    if (this.showSummary) {
                        this.showSummary(engine.getDependencies());
                    }
                }
                catch (IOException ex) {
                    this.log("Unable to generate dependency-check report", ex, 4);
                    throw new BuildException("Unable to generate dependency-check report", (Throwable)ex);
                }
                catch (Exception ex) {
                    this.log("An exception occurred; unable to continue task", ex, 4);
                    throw new BuildException("An exception occurred; unable to continue task", (Throwable)ex);
                }
            }
            catch (DatabaseException ex) {
                this.log("Unable to connect to the dependency-check database; analysis has stopped", ex, 0);
            }
            finally {
                Settings.cleanup((boolean)true);
                if (engine != null) {
                    engine.cleanup();
                }
            }
        }
    }

    private void validateConfiguration() throws BuildException {
        if (this.path == null) {
            throw new BuildException("No project dependencies have been defined to analyze.");
        }
        if (this.failBuildOnCVSS < 0.0f || this.failBuildOnCVSS > 11.0f) {
            throw new BuildException("Invalid configuration, failBuildOnCVSS must be between 0 and 11.");
        }
    }

    @Override
    protected void populateSettings() {
        super.populateSettings();
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
        Settings.setBoolean((String)"analyzer.jar.enabled", (boolean)this.jarAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.python.distribution.enabled", (boolean)this.pyDistributionAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.python.package.enabled", (boolean)this.pyPackageAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.ruby.gemspec.enabled", (boolean)this.rubygemsAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.openssl.enabled", (boolean)this.opensslAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.cmake.enabled", (boolean)this.cmakeAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.autoconf.enabled", (boolean)this.autoconfAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.composer.lock.enabled", (boolean)this.composerAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.node.package.enabled", (boolean)this.nodeAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nuspec.enabled", (boolean)this.nuspecAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.central.enabled", (boolean)this.centralAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nexus.enabled", (boolean)this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString((String)"analyzer.nexus.url", (String)this.nexusUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.proxy", (boolean)this.nexusUsesProxy);
        Settings.setBoolean((String)"analyzer.archive.enabled", (boolean)this.archiveAnalyzerEnabled);
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString((String)"extensions.zip", (String)this.zipExtensions);
        }
        Settings.setBoolean((String)"analyzer.assembly.enabled", (boolean)this.assemblyAnalyzerEnabled);
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
        }
    }

    private void checkForFailure(List<Dependency> dependencies) throws BuildException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (ids.length() == 0) {
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new BuildException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities:%n%n%s%n%nSee the dependency-check report for more details.%n%n", summary.toString());
            this.log(msg, 1);
        }
    }

    public static class ReportFormats
    extends EnumeratedAttribute {
        public String[] getValues() {
            int i = 0;
            ReportGenerator.Format[] formats = ReportGenerator.Format.values();
            String[] values = new String[formats.length];
            for (ReportGenerator.Format format : formats) {
                values[i++] = format.name();
            }
            return values;
        }
    }
}

