/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.cpe;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.owasp.dependencycheck.data.update.NvdCveUpdater;
import org.owasp.dependencycheck.data.update.cpe.Cpe;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CPEHandler
extends DefaultHandler {
    private static final String CURRENT_SCHEMA_VERSION = "2.3";
    private StringBuilder nodeText = null;
    private Element current = new Element();
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveUpdater.class);
    private List<Cpe> data = new ArrayList<Cpe>();

    public List<Cpe> getData() {
        return this.data;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.nodeText = null;
        this.current.setNode(qName);
        if (this.current.isCpeItemNode()) {
            String temp = attributes.getValue("deprecated");
            String value = attributes.getValue("name");
            boolean delete = "true".equalsIgnoreCase(temp);
            if (!delete && value.startsWith("cpe:/a:") && value.length() > 7) {
                try {
                    Cpe cpe = new Cpe(value);
                    this.data.add(cpe);
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.debug("Unable to parse the CPE", ex);
                }
                catch (InvalidDataException ex) {
                    LOGGER.debug("CPE is not the correct format", ex);
                }
            }
        } else if (this.current.isSchemaVersionNode()) {
            this.nodeText = new StringBuilder(3);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nodeText != null) {
            this.nodeText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.setNode(qName);
        if (this.current.isSchemaVersionNode() && !CURRENT_SCHEMA_VERSION.equals(this.nodeText.toString())) {
            throw new SAXException("ERROR: Unexpecgted CPE Schema Version, expected: 2.3, file is: " + this.nodeText);
        }
    }

    protected class Element {
        public static final String CPE_LIST = "cpe-list";
        public static final String CPE_ITEM = "cpe-item";
        public static final String TITLE = "title";
        public static final String NOTES = "notes";
        public static final String NOTE = "note";
        public static final String CHECK = "check";
        public static final String META = "meta:item-metadata";
        public static final String GENERATOR = "generator";
        public static final String PRODUCT_NAME = "product_name";
        public static final String PRODUCT_VERSION = "product_version";
        public static final String SCHEMA_VERSION = "schema_version";
        public static final String TIMESTAMP = "timestamp";
        private String node = null;

        protected Element() {
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public boolean isCpeListNode() {
            return CPE_LIST.equals(this.node);
        }

        public boolean isCpeItemNode() {
            return CPE_ITEM.equals(this.node);
        }

        public boolean isTitleNode() {
            return TITLE.equals(this.node);
        }

        public boolean isNotesNode() {
            return NOTES.equals(this.node);
        }

        public boolean isNoteNode() {
            return NOTE.equals(this.node);
        }

        public boolean isCheckNode() {
            return CHECK.equals(this.node);
        }

        public boolean isMetaNode() {
            return META.equals(this.node);
        }

        public boolean isGeneratorNode() {
            return GENERATOR.equals(this.node);
        }

        public boolean isProductNameNode() {
            return PRODUCT_NAME.equals(this.node);
        }

        public boolean isProductVersionNode() {
            return PRODUCT_VERSION.equals(this.node);
        }

        public boolean isSchemaVersionNode() {
            return SCHEMA_VERSION.equals(this.node);
        }

        public boolean isTimestampNode() {
            return TIMESTAMP.equals(this.node);
        }
    }
}

