/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class UrlStringUtils {
    private static final Pattern CONTAINS_URL_TEST = Pattern.compile("^.*(ht|f)tps?://.*$", 10);
    private static final Pattern IS_URL_TEST = Pattern.compile("^(ht|f)tps?://.*", 2);
    private static final Set<String> IGNORE_LIST = new HashSet<String>(Arrays.asList("www", "com", "org", "gov", "info", "name", "net", "pro", "tel", "mobi", "xxx"));

    private UrlStringUtils() {
    }

    public static boolean containsUrl(String text) {
        return CONTAINS_URL_TEST.matcher(text).matches();
    }

    public static boolean isUrl(String text) {
        return IS_URL_TEST.matcher(text).matches();
    }

    public static List<String> extractImportantUrlData(String text) throws MalformedURLException {
        ArrayList<String> importantParts = new ArrayList<String>();
        URL url = new URL(text);
        String[] domain = url.getHost().split("\\.");
        for (int i = 0; i < domain.length - 1; ++i) {
            String sub = domain[i];
            if (IGNORE_LIST.contains(sub.toLowerCase())) continue;
            importantParts.add(sub);
        }
        String document = url.getPath();
        String[] pathParts = document.split("[\\//]");
        for (int i = 0; i < pathParts.length - 2; ++i) {
            if (pathParts[i].isEmpty()) continue;
            importantParts.add(pathParts[i]);
        }
        if (pathParts.length > 0 && !pathParts[pathParts.length - 1].isEmpty()) {
            String fileNameNoExt = pathParts[pathParts.length - 1].replaceAll("\\..*{0,5}$", "");
            importantParts.add(fileNameNoExt);
        }
        return importantParts;
    }
}

