/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import org.owasp.dependencycheck.dependency.Confidence;

public class Evidence
implements Serializable,
Comparable<Evidence> {
    private String name;
    private String source;
    private String value;
    private boolean used;
    private Confidence confidence;

    public Evidence() {
    }

    public Evidence(String source, String name, String value, Confidence confidence) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.confidence = confidence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getValue() {
        this.used = true;
        return this.value;
    }

    public String getValue(Boolean setUsed) {
        this.used = this.used || setUsed != false;
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.source != null ? this.source.hashCode() : 0);
        hash = 67 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 67 * hash + (this.confidence != null ? this.confidence.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Evidence)) {
            return false;
        }
        Evidence e = (Evidence)that;
        return this.testEquality(this.name, e.name) && this.testEquality(this.source, e.source) && this.testEquality(this.value, e.value) && (this.confidence == null ? e.confidence == null : this.confidence == e.confidence);
    }

    private boolean testEquality(String l, String r) {
        return l == null ? r == null : l.equalsIgnoreCase(r);
    }

    @Override
    public int compareTo(Evidence o) {
        if (o == null) {
            return 1;
        }
        if (this.equalsWithNullCheck(this.source, o.source)) {
            if (this.equalsWithNullCheck(this.name, o.name)) {
                if (this.equalsWithNullCheck(this.value, o.value)) {
                    if (this.equalsWithNullCheck(this.confidence, o.confidence)) {
                        return 0;
                    }
                    return this.compareToWithNullCheck(this.confidence, o.confidence);
                }
                return this.compareToIgnoreCaseWithNullCheck(this.value, o.value);
            }
            return this.compareToIgnoreCaseWithNullCheck(this.name, o.name);
        }
        return this.compareToIgnoreCaseWithNullCheck(this.source, o.source);
    }

    private boolean equalsWithNullCheck(String me, String other) {
        if (me == null && other == null) {
            return true;
        }
        if (me == null || other == null) {
            return false;
        }
        return me.equals(other);
    }

    private boolean equalsWithNullCheck(Confidence me, Confidence other) {
        if (me == null && other == null) {
            return true;
        }
        if (me == null || other == null) {
            return false;
        }
        return me.equals((Object)other);
    }

    private int compareToIgnoreCaseWithNullCheck(String me, String other) {
        if (me == null && other == null) {
            return 0;
        }
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return me.compareToIgnoreCase(other);
    }

    private int compareToWithNullCheck(Confidence me, Confidence other) {
        if (me == null && other == null) {
            return 0;
        }
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return me.compareTo(other);
    }
}

