/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;

public class MVDelegateIndex
extends BaseIndex {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable mVTable, int n, String string, MVPrimaryIndex mVPrimaryIndex, IndexType indexType) {
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{mVTable.getColumn(mVPrimaryIndex.getMainIndexColumn())});
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        this.mainIndex = mVPrimaryIndex;
        if (n < 0) {
            throw DbException.throwInternalError("" + string);
        }
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = this.mainIndex.getKey(searchRow, Long.MIN_VALUE, Long.MIN_VALUE);
        long l2 = this.mainIndex.getKey(searchRow2, Long.MAX_VALUE, Long.MIN_VALUE);
        return this.mainIndex.find(session, l, l2);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        return this.mainIndex.findFirstOrLast(session, bl);
    }

    @Override
    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public double getCost(Session session, int[] nArray, SortOrder sortOrder) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCount(session), sortOrder);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

