/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.table.TableBase;
import org.h2.util.New;

public class MVTableEngine
implements TableEngine {
    @Override
    public TableBase createTable(CreateTableData createTableData) {
        Object object;
        Database database = createTableData.session.getDatabase();
        Store store = database.getMvStore();
        if (store == null) {
            object = database.getFilePasswordHash();
            String string = database.getDatabasePath();
            MVStore.Builder builder = new MVStore.Builder();
            if (string == null) {
                store = new Store(database, builder.open());
            } else {
                builder.fileName(string + ".mv.db");
                if (database.isReadOnly()) {
                    builder.readOnly();
                }
                if (object != null) {
                    char[] cArray = new char[((Object)object).length];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        cArray[i] = (char)object[i];
                    }
                    builder.encryptionKey(cArray);
                }
                store = new Store(database, builder.open());
            }
            database.setMvStore(store);
        }
        object = new MVTable(createTableData, store);
        store.openTables.add((MVTable)object);
        ((MVTable)object).init(createTableData.session);
        return object;
    }

    public static class Store {
        final Database db;
        final ArrayList<MVTable> openTables = New.arrayList();
        private final MVStore store;
        private final TransactionStore transactionStore;

        public Store(Database database, MVStore mVStore) {
            this.db = database;
            this.store = mVStore;
            this.transactionStore = new TransactionStore(mVStore, new ValueDataType(null, null, null));
        }

        public MVStore getStore() {
            return this.store;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }

        public List<MVTable> getTables() {
            return this.openTables;
        }

        public void removeTable(MVTable mVTable) {
            this.openTables.remove(mVTable);
        }

        public void store() {
            if (!this.store.isReadOnly()) {
                this.store.commit();
                this.store.compact(50);
                this.store.store();
            }
        }

        public void closeImmediately() {
            if (this.store.isClosed()) {
                return;
            }
            FileChannel fileChannel = this.store.getFile();
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, "Closing file");
                }
            }
        }

        public void close() {
            if (!this.store.isClosed()) {
                if (!this.store.isReadOnly()) {
                    this.store.store();
                }
                this.store.close();
            }
        }

        public void setWriteDelay(int n) {
            this.store.setWriteDelay(n);
        }
    }
}

