/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.exception.UpdateException;

public class DatabaseProperties {
    private static final Logger LOGGER = Logger.getLogger(DatabaseProperties.class.getName());
    public static final String MODIFIED = "Modified";
    public static final String LAST_UPDATED = "NVD CVE Modified";
    public static final String LAST_UPDATED_BASE = "NVD CVE ";
    private Properties properties;
    private CveDB cveDB;

    DatabaseProperties(CveDB cveDB) {
        this.cveDB = cveDB;
        this.loadProperties();
    }

    private void loadProperties() {
        this.properties = this.cveDB.getProperties();
    }

    public boolean isEmpty() {
        return this.properties == null || this.properties.isEmpty();
    }

    public void save(NvdCveInfo updatedValue) throws UpdateException {
        if (updatedValue == null) {
            return;
        }
        this.properties.put(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
        this.cveDB.saveProperty(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map getMetaData() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if ("version".equals(key)) continue;
            if (key.startsWith(LAST_UPDATED_BASE)) {
                try {
                    long epoch = Long.parseLong((String)entry.getValue());
                    Date date = new Date(epoch);
                    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    String formatted = format.format(date);
                    map.put(key, formatted);
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.FINE, "Unable to parse timestamp from DB", ex);
                    map.put(key, entry.getValue());
                }
                continue;
            }
            map.put(key, entry.getValue());
        }
        return map;
    }
}

