/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.suppression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.suppression.PropertyType;

public class SuppressionRule {
    private PropertyType filePath;
    private String sha1;
    private List<PropertyType> cpe = new ArrayList<PropertyType>();
    private List<Float> cvssBelow = new ArrayList<Float>();
    private List<String> cwe = new ArrayList<String>();
    private List<String> cve = new ArrayList<String>();

    public PropertyType getFilePath() {
        return this.filePath;
    }

    public void setFilePath(PropertyType filePath) {
        this.filePath = filePath;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public List<PropertyType> getCpe() {
        return this.cpe;
    }

    public void setCpe(List<PropertyType> cpe) {
        this.cpe = cpe;
    }

    public void addCpe(PropertyType cpe) {
        this.cpe.add(cpe);
    }

    public boolean hasCpe() {
        return this.cpe.size() > 0;
    }

    public List<Float> getCvssBelow() {
        return this.cvssBelow;
    }

    public void setCvssBelow(List<Float> cvssBelow) {
        this.cvssBelow = cvssBelow;
    }

    public void addCvssBelow(Float cvss) {
        this.cvssBelow.add(cvss);
    }

    public boolean hasCvssBelow() {
        return this.cvssBelow.size() > 0;
    }

    public List<String> getCwe() {
        return this.cwe;
    }

    public void setCwe(List<String> cwe) {
        this.cwe = cwe;
    }

    public void addCwe(String cwe) {
        this.cwe.add(cwe);
    }

    public boolean hasCwe() {
        return this.cwe.size() > 0;
    }

    public List<String> getCve() {
        return this.cve;
    }

    public void setCve(List<String> cve) {
        this.cve = cve;
    }

    public void addCve(String cve) {
        this.cve.add(cve);
    }

    public boolean hasCve() {
        return this.cve.size() > 0;
    }

    public void process(Dependency dependency) {
        Iterator<Identifier> itr;
        if (this.filePath != null && !this.filePath.matches(dependency.getFilePath())) {
            return;
        }
        if (this.sha1 != null && !this.sha1.equalsIgnoreCase(dependency.getSha1sum())) {
            return;
        }
        if (this.hasCpe()) {
            itr = dependency.getIdentifiers().iterator();
            block0: while (itr.hasNext()) {
                Identifier i = itr.next();
                for (PropertyType c : this.cpe) {
                    if (!this.cpeMatches(c, i)) continue;
                    dependency.addSuppressedIdentifier(i);
                    itr.remove();
                    continue block0;
                }
            }
        }
        if (this.hasCve() || this.hasCwe() || this.hasCvssBelow()) {
            itr = dependency.getVulnerabilities().iterator();
            while (itr.hasNext()) {
                boolean remove = false;
                Vulnerability v = (Vulnerability)((Object)itr.next());
                for (String entry : this.cve) {
                    if (!entry.equalsIgnoreCase(v.getName())) continue;
                    remove = true;
                    break;
                }
                if (!remove) {
                    for (String entry : this.cwe) {
                        if (v.getCwe() == null) continue;
                        String toMatch = String.format("CWE-%s ", entry);
                        String toTest = v.getCwe().substring(0, toMatch.length()).toUpperCase();
                        if (!toTest.equals(toMatch)) continue;
                        remove = true;
                        break;
                    }
                }
                if (!remove) {
                    Iterator<Object> i$ = this.cvssBelow.iterator();
                    while (i$.hasNext()) {
                        float cvss = ((Float)i$.next()).floatValue();
                        if (!(v.getCvssScore() < cvss)) continue;
                        remove = true;
                        break;
                    }
                }
                if (!remove) continue;
                dependency.addSuppressedVulnerability(v);
                itr.remove();
            }
        }
    }

    boolean cpeHasNoVersion(PropertyType c) {
        if (c.isRegex()) {
            return false;
        }
        return this.countCharacter(c.getValue(), ':') == 3;
    }

    int countCharacter(String str, char c) {
        int count = 0;
        int pos = str.indexOf(c) + 1;
        while (pos > 0) {
            ++count;
            pos = str.indexOf(c, pos) + 1;
        }
        return count;
    }

    boolean cpeMatches(PropertyType cpeEntry, Identifier identifier) {
        String check;
        String id;
        if (cpeEntry.matches(identifier.getValue())) {
            return true;
        }
        return this.cpeHasNoVersion(cpeEntry) && (cpeEntry.isCaseSensitive() ? identifier.getValue().startsWith(cpeEntry.getValue()) : (id = identifier.getValue().toLowerCase()).startsWith(check = cpeEntry.getValue().toLowerCase()));
    }
}

