/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.EliasFanoEncoder;

public class EliasFanoDecoder {
    private static final int LOG2_LONG_SIZE = Long.numberOfTrailingZeros(64L);
    private final EliasFanoEncoder efEncoder;
    final long numEncoded;
    private long efIndex = -1L;
    private long setBitForIndex = -1L;
    public static final long NO_MORE_VALUES = -1L;
    private long curHighLong;

    public EliasFanoDecoder(EliasFanoEncoder efEncoder) {
        this.efEncoder = efEncoder;
        this.numEncoded = efEncoder.numEncoded;
    }

    public EliasFanoEncoder getEliasFanoEncoder() {
        return this.efEncoder;
    }

    public long index() {
        if (this.efIndex < 0L) {
            throw new IllegalStateException("index before sequence");
        }
        if (this.efIndex >= this.numEncoded) {
            throw new IllegalStateException("index after sequence");
        }
        return this.efIndex;
    }

    private long currentHighValue() {
        return this.setBitForIndex - this.efIndex;
    }

    private long currentLowValue() {
        assert (this.efIndex >= 0L);
        assert (this.efIndex < this.numEncoded);
        if (this.efEncoder.numLowBits == 0) {
            return 0L;
        }
        long bitPos = this.efIndex * (long)this.efEncoder.numLowBits;
        int lowIndex = (int)(bitPos >>> LOG2_LONG_SIZE);
        int bitPosAtIndex = (int)(bitPos & 0x3FL);
        long lowValue = this.efEncoder.lowerLongs[lowIndex] >>> bitPosAtIndex;
        if (bitPosAtIndex + this.efEncoder.numLowBits > 64) {
            lowValue |= this.efEncoder.lowerLongs[lowIndex + 1] << 64 - bitPosAtIndex;
        }
        return lowValue &= this.efEncoder.lowerBitsMask;
    }

    private long combineHighLowValues(long highValue, long lowValue) {
        return highValue << this.efEncoder.numLowBits | lowValue;
    }

    public void toBeforeSequence() {
        this.efIndex = -1L;
        this.setBitForIndex = -1L;
    }

    private int getCurrentRightShift() {
        int s = (int)(this.setBitForIndex & 0x3FL);
        return s;
    }

    private boolean toAfterCurrentHighBit() {
        ++this.efIndex;
        if (this.efIndex >= this.numEncoded) {
            return false;
        }
        ++this.setBitForIndex;
        int highIndex = (int)(this.setBitForIndex >>> LOG2_LONG_SIZE);
        this.curHighLong = this.efEncoder.upperLongs[highIndex] >>> this.getCurrentRightShift();
        return true;
    }

    private void toNextHighLong() {
        this.setBitForIndex += 64L - (this.setBitForIndex & 0x3FL);
        int highIndex = (int)(this.setBitForIndex >>> LOG2_LONG_SIZE);
        this.curHighLong = this.efEncoder.upperLongs[highIndex];
    }

    private void toNextHighValue() {
        while (this.curHighLong == 0L) {
            this.toNextHighLong();
        }
        this.setBitForIndex += (long)Long.numberOfTrailingZeros(this.curHighLong);
    }

    private long nextHighValue() {
        this.toNextHighValue();
        return this.currentHighValue();
    }

    public long nextValue() {
        if (!this.toAfterCurrentHighBit()) {
            return -1L;
        }
        long highValue = this.nextHighValue();
        return this.combineHighLowValues(highValue, this.currentLowValue());
    }

    public boolean advanceToIndex(long index) {
        assert (index > this.efIndex);
        if (index >= this.numEncoded) {
            this.efIndex = this.numEncoded;
            return false;
        }
        if (!this.toAfterCurrentHighBit()) assert (false);
        int curSetBits = Long.bitCount(this.curHighLong);
        while (this.efIndex + (long)curSetBits < index) {
            this.efIndex += (long)curSetBits;
            this.toNextHighLong();
            curSetBits = Long.bitCount(this.curHighLong);
        }
        while (this.efIndex < index) {
            if (!this.toAfterCurrentHighBit()) assert (false);
            this.toNextHighValue();
        }
        return true;
    }

    private long advanceToHighValue(long highTarget) {
        int curSetBits = Long.bitCount(this.curHighLong);
        int curClearBits = 64 - curSetBits - this.getCurrentRightShift();
        while (this.currentHighValue() + (long)curClearBits < highTarget) {
            this.efIndex += (long)curSetBits;
            if (this.efIndex >= this.numEncoded) {
                return -1L;
            }
            this.toNextHighLong();
            curSetBits = Long.bitCount(this.curHighLong);
            curClearBits = 64 - curSetBits;
        }
        long highValue = this.nextHighValue();
        while (highValue < highTarget) {
            if (!this.toAfterCurrentHighBit()) {
                return -1L;
            }
            highValue = this.nextHighValue();
        }
        return highValue;
    }

    public long advanceToValue(long target) {
        if (!this.toAfterCurrentHighBit()) {
            return -1L;
        }
        long highTarget = target >>> this.efEncoder.numLowBits;
        long highValue = this.advanceToHighValue(highTarget);
        if (highValue == -1L) {
            return -1L;
        }
        long currentValue = this.combineHighLowValues(highValue, this.currentLowValue());
        while (currentValue < target) {
            currentValue = this.nextValue();
            if (currentValue != -1L) continue;
            return -1L;
        }
        return currentValue;
    }

    public void toAfterSequence() {
        this.efIndex = this.numEncoded;
        this.setBitForIndex = (this.efEncoder.lastEncoded >>> this.efEncoder.numLowBits) + this.numEncoded;
    }

    private int getCurrentLeftShift() {
        int s = 63 - (int)(this.setBitForIndex & 0x3FL);
        return s;
    }

    private boolean toBeforeCurrentHighBit() {
        --this.efIndex;
        if (this.efIndex < 0L) {
            return false;
        }
        --this.setBitForIndex;
        int highIndex = (int)(this.setBitForIndex >>> LOG2_LONG_SIZE);
        this.curHighLong = this.efEncoder.upperLongs[highIndex] << this.getCurrentLeftShift();
        return true;
    }

    private void toPreviousHighLong() {
        this.setBitForIndex -= (this.setBitForIndex & 0x3FL) + 1L;
        int highIndex = (int)(this.setBitForIndex >>> LOG2_LONG_SIZE);
        this.curHighLong = this.efEncoder.upperLongs[highIndex];
    }

    private long previousHighValue() {
        while (this.curHighLong == 0L) {
            this.toPreviousHighLong();
        }
        this.setBitForIndex -= (long)Long.numberOfLeadingZeros(this.curHighLong);
        return this.currentHighValue();
    }

    public long previousValue() {
        if (!this.toBeforeCurrentHighBit()) {
            return -1L;
        }
        long highValue = this.previousHighValue();
        return this.combineHighLowValues(highValue, this.currentLowValue());
    }

    private long backToHighValue(long highTarget) {
        int curSetBits = Long.bitCount(this.curHighLong);
        int curClearBits = 64 - curSetBits - this.getCurrentLeftShift();
        while (this.currentHighValue() - (long)curClearBits > highTarget) {
            this.efIndex -= (long)curSetBits;
            if (this.efIndex < 0L) {
                return -1L;
            }
            this.toPreviousHighLong();
            curSetBits = Long.bitCount(this.curHighLong);
            curClearBits = 64 - curSetBits;
        }
        long highValue = this.previousHighValue();
        while (highValue > highTarget) {
            if (!this.toBeforeCurrentHighBit()) {
                return -1L;
            }
            highValue = this.previousHighValue();
        }
        return highValue;
    }

    public long backToValue(long target) {
        if (!this.toBeforeCurrentHighBit()) {
            return -1L;
        }
        long highTarget = target >>> this.efEncoder.numLowBits;
        long highValue = this.backToHighValue(highTarget);
        if (highValue == -1L) {
            return -1L;
        }
        long currentValue = this.combineHighLowValues(highValue, this.currentLowValue());
        while (currentValue > target) {
            currentValue = this.previousValue();
            if (currentValue != -1L) continue;
            return -1L;
        }
        return currentValue;
    }
}

