/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.properties;

import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.owasp.csrfguard.config.properties.SimpleBooleanConfigParameter;
import org.owasp.csrfguard.config.properties.SimpleConfigParameter;
import org.owasp.csrfguard.config.properties.SimpleDurationParameter;
import org.owasp.csrfguard.config.properties.SimpleIntConfigParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static String getProperty(Properties properties, String propertyName) {
        return PropertyUtils.getProperty(properties, propertyName, null);
    }

    public static String getProperty(Properties properties, Pair<String, String> propertyWithDefaultValue) {
        return PropertyUtils.getProperty(properties, (String)propertyWithDefaultValue.getKey(), (String)propertyWithDefaultValue.getValue());
    }

    public static int getProperty(Properties properties, SimpleIntConfigParameter configParameter) {
        return PropertyUtils.getProperty(properties, configParameter, Integer::parseInt);
    }

    public static boolean getProperty(Properties properties, SimpleBooleanConfigParameter configParameter) {
        return PropertyUtils.getProperty(properties, configParameter, Boolean::parseBoolean);
    }

    public static <T> T getProperty(Properties properties, SimpleConfigParameter<T> configParameter, Function<String, T> function) {
        return PropertyUtils.getProperty(properties, configParameter.getName(), configParameter.getDefaultValue(), function);
    }

    public static Duration getProperty(Properties properties, SimpleDurationParameter configParameter) {
        return PropertyUtils.getProperty(properties, configParameter.getName(), configParameter.getDefaultValue(), millis -> Duration.ofMillis(Long.parseLong(millis)));
    }

    public static <T> T getProperty(Properties properties, String propertyName, T defaultValue, Function<String, T> function) {
        String property = PropertyUtils.getProperty(properties, propertyName);
        return StringUtils.isBlank((CharSequence)property) ? defaultValue : function.apply(property);
    }

    public static String getProperty(Properties properties, String propertyName, String defaultValue) {
        String value;
        if (Objects.isNull(defaultValue)) {
            value = properties.getProperty(propertyName);
        } else {
            if (!properties.containsKey(propertyName)) {
                LOGGER.info("The '{}' property was not defined, using '{}' as default value. %n", (Object)propertyName, (Object)defaultValue);
            }
            value = properties.getProperty(propertyName, defaultValue);
        }
        return PropertyUtils.commonSubstitutions(value);
    }

    public static String commonSubstitutions(String input) {
        if (!StringUtils.contains((CharSequence)input, (CharSequence)"%")) {
            return input;
        }
        return input.replace("%servletContext%", StringUtils.defaultString((String)CsrfGuardServletContextListener.getServletContext()));
    }
}

