/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.util.Streams;

public class CsrfGuardServletContextListener
implements ServletContextListener {
    private static final String CONFIG_PARAM = "Owasp.CsrfGuard.Config";
    private static final String CONFIG_PRINT_PARAM = "Owasp.CsrfGuard.Config.Print";
    private static String servletContext = null;
    private static String configFileName = null;

    public static String getServletContext() {
        return servletContext;
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        servletContext = context.getContextPath();
        if (servletContext == null || "/".equals(servletContext)) {
            servletContext = "";
        }
        if ((configFileName = context.getInitParameter(CONFIG_PARAM)) == null) {
            configFileName = "Owasp.CsrfGuard.properties";
        }
        InputStream is = null;
        Properties properties = new Properties();
        try {
            is = this.getResourceStream(configFileName, context, false);
            if (is == null) {
                is = this.getResourceStream("META-INF/csrfguard.properties", context, false);
            }
            if (is == null) {
                throw new RuntimeException("Cant find default owasp csrfguard properties file: " + configFileName);
            }
            properties.load(is);
            CsrfGuard.load(properties);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Streams.close(is);
                throw throwable;
            }
        }
        Streams.close(is);
        CsrfGuardServletContextListener.printConfigIfConfigured(context, "Printing properties before Javascript servlet, note, the javascript properties might not be initialized yet: ");
    }

    public static void printConfigIfConfigured(ServletContext context, String prefix) {
        String printConfig = context.getInitParameter(CONFIG_PRINT_PARAM);
        if (printConfig == null || "".equals(printConfig.trim())) {
            String string = printConfig = CsrfGuard.getInstance().isPrintConfig() ? "true" : null;
        }
        if (printConfig != null && Boolean.parseBoolean(printConfig)) {
            context.log(prefix + CsrfGuard.getInstance().toString());
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    private InputStream getResourceStream(String resourceName, ServletContext context, boolean failIfNotFound) throws IOException {
        File file;
        String fileName;
        File file2;
        InputStream is = null;
        is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (is == null && (file2 = new File(fileName = context.getRealPath(resourceName))).exists()) {
            is = new FileInputStream(fileName);
        }
        if (is == null && (file = new File(resourceName)).exists()) {
            is = new FileInputStream(resourceName);
        }
        if (is == null && failIfNotFound) {
            throw new IOException(String.format("unable to locate resource - %s", resourceName));
        }
        return is;
    }
}

