/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.openstack.model.identity.keystone;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.xlcloud.openstack.model.identity.Authentication;
import org.xlcloud.openstack.model.identity.Token;
import org.xlcloud.openstack.model.identity.keystone.KeystoneApiAccessKeyCredentials;
import org.xlcloud.openstack.model.identity.keystone.KeystonePasswordCredentials;
import org.xlcloud.openstack.model.identity.keystone.KeystoneToken;

@XmlRootElement(name="auth", namespace="")
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonRootName(value="auth")
public class KeystoneAuthentication
implements Serializable,
Authentication {
    @XmlElement(type=KeystoneToken.class)
    private KeystoneToken token;
    @XmlElement(namespace="", name="passwordCredentials")
    @JsonProperty
    private KeystonePasswordCredentials passwordCredentials;
    @XmlElement(namespace="", name="apiAccessKeyCredentials")
    @JsonProperty
    private KeystoneApiAccessKeyCredentials apiAccessKeyCredentials;
    @XmlAttribute
    private String tenantId;
    @XmlAttribute
    private String tenantName;

    private KeystoneAuthentication() {
    }

    public static KeystoneAuthentication withPasswordCredentials(String username, String password) {
        KeystoneAuthentication auth = new KeystoneAuthentication();
        auth.passwordCredentials = new KeystonePasswordCredentials();
        auth.passwordCredentials.setUsername(username);
        auth.passwordCredentials.setPassword(password);
        return auth;
    }

    public static KeystoneAuthentication withApiAccessKeyCredentials(String accessKey, String secretKey) {
        KeystoneAuthentication auth = new KeystoneAuthentication();
        auth.apiAccessKeyCredentials = new KeystoneApiAccessKeyCredentials();
        auth.apiAccessKeyCredentials.setAccessKey(accessKey);
        auth.apiAccessKeyCredentials.setSecretKey(secretKey);
        return auth;
    }

    public static KeystoneAuthentication withTokenAndTenant(String tokenId, String tenantId) {
        KeystoneAuthentication auth = new KeystoneAuthentication();
        auth.token = new KeystoneToken();
        auth.token.setId(tokenId);
        auth.tenantId = tenantId;
        return auth;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public void setToken(KeystoneToken token) {
        this.token = token;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String toString() {
        return "KeyStoneAuthentication [token=" + this.token + ", passwordCredentials=" + this.passwordCredentials + ", tenantId=" + this.tenantId + ", tenantName=" + this.tenantName + "]";
    }
}

