/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.ow2.util.ant.archive.api.IEjb;
import org.ow2.util.ant.archive.exploded.EjbExploded;
import org.ow2.util.ant.archive.file.EjbFile;
import org.ow2.util.ant.archive.info.EjbInfo;

/**
 * Task that creates an EJB jar archive (.jar file or .jar directory).
 * @author Florent Benoit
 */
public class Ejb extends AbsArchive {

    /**
     * Reference to the persistence deployment descriptor.
     */
    private File persistenceDeploymentDescriptor = null;

    /**
     * Default constructor.
     */
    public Ejb() {
        super();
    }

    /**
     * Sets the reference to the persistence deployment descriptor.
     * @param persistenceDD the given persistence deployment descriptor.
     */
    public void setPersistenceDD(final File persistenceDD) {
        // Ignore empty value
        if ("empty-value".equals(persistenceDD.getName())) {
            return;
        }

        if (!persistenceDD.exists()) {
            throw new BuildException("The given file '" + persistenceDD + "' for the deployment descriptor does not exist.");
        }
        this.persistenceDeploymentDescriptor = persistenceDD;
    }

    /**
     * Execute the task by using either exploded or file mode.
     */
    @Override
    public void execute() {

        log("Building Ejb in '" + getDest() + "'.", Project.MSG_INFO);

        IEjb ejb = null;

        // 2 cases, exploded mode or not
        if (isExploded()) {
            ejb = new EjbExploded(getProject());
        } else {
            ejb = new EjbFile(getProject());
        }

        // Set the name of the task
        ((Task) ejb).setTaskName(getTaskName());

        // Build the info object
        EjbInfo ejbInfo = new EjbInfo();
        ejb.setEjbInfo(ejbInfo);

        // Fill archive properties
        updateArchiveInfo(ejbInfo);
        ejbInfo.setPersistenceDD(persistenceDeploymentDescriptor);

        // Execute the task
        ejb.execute();

    }

}
