/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.java2wsdl;

import java.util.HashMap;
import java.util.Map;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;

public class WSDLGenerationContext {
    private Description description;
    private Map<String, Schema> schemas = new HashMap<String, Schema>();

    public Description processWSDL() throws WSDLException {
        Types types = (Types)this.description.createTypes();
        this.description.setTypes((AbsItfTypes)types);
        for (Map.Entry<String, Schema> schemaEntry : this.schemas.entrySet()) {
            types.addSchema((AbsItfSchema)schemaEntry.getValue());
        }
        return this.description;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public Schema getSchema(String namespace) {
        Schema schema = this.schemas.get(namespace);
        if (schema == null) {
            try {
                schema = SchemaFactory.newInstance().newSchema();
                schema.setTargetNamespace(namespace);
            }
            catch (SchemaException e) {
                e.printStackTrace();
            }
            this.schemas.put(namespace, schema);
        }
        return schema;
    }
}

