package org.ow2.easywsdl.tooling.java2wsdl;

import java.util.HashMap;
import java.util.Map;

import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;

public class WSDLGenerationContext {

	private Description description;

	private Map<String, Schema> schemas = new HashMap<String, Schema>();


	public Description processWSDL() throws WSDLException {
		
		Types types = description.createTypes();
		description.setTypes(types);
		
		for (Map.Entry<String, Schema> schemaEntry : schemas.entrySet()) {
			types.addSchema(schemaEntry.getValue());
		}
				
		return description;
	}

	public Description getDescription() {
		return description;
	}

	public void setDescription(Description description) {
		this.description = description;
	}

	public Schema getSchema(String namespace) {
		Schema schema = schemas.get(namespace);

		if (schema == null) {
			try {
				schema = SchemaFactory.newInstance().newSchema();
				schema.setTargetNamespace(namespace);
			} catch (SchemaException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			schemas.put(namespace, schema);
		}

		return schema;
	}
}
