/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.multiple.impl;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.extensions.multiple.MultipleExtFactory;
import org.ow2.easywsdl.extensions.multiple.api.Description;
import org.ow2.easywsdl.extensions.multiple.api.MultipleExtException;
import org.ow2.easywsdl.extensions.multiple.api.MultipleExtReader;
import org.ow2.easywsdl.wsdl.ExtensionFactory;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class MultipleExtReaderImpl
implements MultipleExtReader {
    private WSDLReader reader = null;

    public MultipleExtReaderImpl() throws MultipleExtException {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            this.reader = factory.newWSDLReader();
        }
        catch (WSDLException e) {
            throw new MultipleExtException(e);
        }
    }

    @Override
    public Object getFeature(WSDLReader.FeatureConstants name) {
        return this.reader.getFeature(name);
    }

    @Override
    public Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        return this.reader.getFeatures();
    }

    public void setFeatures(Map<WSDLReader.FeatureConstants, Object> features) {
        ((AbstractWSDLReaderImpl)this.reader).setFeatures(features);
    }

    @Override
    public Description read(URL wsdlURL) throws MultipleExtException, IOException, URISyntaxException {
        ArrayList<ExtensionFactory> emptyList = new ArrayList<ExtensionFactory>();
        return this.read(emptyList, wsdlURL);
    }

    @Override
    public Description read(List<ExtensionFactory> extFactories, URL wsdlURL) throws MultipleExtException, IOException, URISyntaxException {
        try {
            InputSource inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            return this.read(extFactories, inputSource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
        }
        catch (WSDLException e) {
            throw new MultipleExtException(e);
        }
    }

    @Override
    public Description read(List<ExtensionFactory> extFactories, Document wsdlDocument) throws MultipleExtException, URISyntaxException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(wsdlDocument), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(wsdlDocument.getBaseURI());
            Description description = this.read(extFactories, documentInputSource);
            return description;
        }
        catch (TransformerException e) {
            throw new MultipleExtException(e);
        }
        catch (IOException e) {
            throw new MultipleExtException(e);
        }
        finally {
            Transformers.releaseTransformer((Transformer)transformer);
        }
    }

    @Override
    public Description read(List<ExtensionFactory> extFactories, InputSource wsdlInputSource) throws MultipleExtException, MalformedURLException, URISyntaxException {
        try {
            org.ow2.easywsdl.wsdl.api.Description desc = this.reader.read(wsdlInputSource);
            return MultipleExtFactory.newInstance().addMultipleExtElmt2Description(extFactories, (AbsItfDescription)desc);
        }
        catch (WSDLException e) {
            throw new MultipleExtException(e);
        }
    }

    @Override
    public void setFeature(WSDLReader.FeatureConstants name, Object value) throws WSDLException {
        this.reader.setFeature(name, value);
    }
}

