/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.StringTokenizer;

final class Util {
    private Util() {
    }

    static int getMajorJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        StringTokenizer tokenizer = new StringTokenizer(javaVersion, "._");
        String javaMajorVersionText = tokenizer.nextToken();
        int majorVersion = Integer.parseInt(javaMajorVersionText);
        if (majorVersion != 1) {
            return majorVersion;
        }
        javaMajorVersionText = tokenizer.nextToken();
        return Integer.parseInt(javaMajorVersionText);
    }

    static boolean previewFeatureEnabled() {
        try {
            Class<?> managementFactoryClass = Class.forName("java.lang.management.ManagementFactory");
            Method getRuntimeMxBean = managementFactoryClass.getMethod("getRuntimeMXBean", new Class[0]);
            Object runtimeMxBean = getRuntimeMxBean.invoke(null, new Object[0]);
            Class<?> runtimeMxBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Method getInputArguments = runtimeMxBeanClass.getMethod("getInputArguments", new Class[0]);
            List argumentList = (List)getInputArguments.invoke(runtimeMxBean, new Object[0]);
            return argumentList.contains("--enable-preview");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }
}

