/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;
import org.objectweb.asm.test.ClassFormatException;
import org.objectweb.asm.test.Util;

public abstract class AsmTest {
    private static final int INPUT_STREAM_DATA_CHUNK_SIZE = 4096;
    public static final String ALL_CLASSES_AND_ALL_APIS = "allClassesAndAllApis";
    public static final String ALL_CLASSES_AND_LATEST_API = "allClassesAndLatestApi";
    public static final String UNSUPPORTED_OPERATION_MESSAGE_PATTERN = ".* requires ASM[56789].*";

    public static Stream<Arguments> allClassesAndAllApis() {
        return AsmTest.classesAndApis(Api.values());
    }

    public static Stream<Arguments> allClassesAndLatestApi() {
        return AsmTest.classesAndApis(Api.ASM9);
    }

    private static Stream<Arguments> classesAndApis(Api ... apis) {
        return Arrays.stream(PrecompiledClass.values()).flatMap(precompiledClass -> Arrays.stream(apis).map(api -> Arguments.of((Object[])new Object[]{precompiledClass, api})));
    }

    private static byte[] getBytes(String name, String extension) {
        byte[] byArray;
        block10: {
            String resourceName = name.replace('.', '/') + extension;
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(resourceName);
            try {
                int bytesRead;
                if (inputStream == null) {
                    throw new IllegalArgumentException("Class not found " + name);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                    outputStream.write(data, 0, bytesRead);
                }
                outputStream.flush();
                byArray = outputStream.toByteArray();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassFormatException("Can't read " + name, e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public static enum Api {
        ASM4("ASM4", 262144),
        ASM5("ASM5", 327680),
        ASM6("ASM6", 393216),
        ASM7("ASM7", 458752),
        ASM8("ASM8", 524288),
        ASM9("ASM9", 589824);

        private final String name;
        private final int value;

        private Api(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum PrecompiledClass {
        DEFAULT_PACKAGE("DefaultPackage"),
        JDK3_ALL_INSTRUCTIONS("jdk3.AllInstructions"),
        JDK3_ALL_STRUCTURES("jdk3.AllStructures"),
        JDK3_ANONYMOUS_INNER_CLASS("jdk3.AllStructures$1"),
        JDK3_ARTIFICIAL_STRUCTURES("jdk3.ArtificialStructures"),
        JDK3_INNER_CLASS("jdk3.AllStructures$InnerClass"),
        JDK3_LARGE_METHOD("jdk3.LargeMethod"),
        JDK3_SUB_OPTIMAL_MAX_STACK_AND_LOCALS("jdk3.SubOptimalMaxStackAndLocals"),
        JDK5_ALL_INSTRUCTIONS("jdk5.AllInstructions"),
        JDK5_ALL_STRUCTURES("jdk5.AllStructures"),
        JDK5_ANNOTATION("jdk5.AllStructures$InvisibleAnnotation"),
        JDK5_ENUM("jdk5.AllStructures$EnumClass"),
        JDK5_LOCAL_CLASS("jdk5.AllStructures$1LocalClass"),
        JDK8_ALL_FRAMES("jdk8.AllFrames", JdkVersion.JDK8),
        JDK8_ALL_INSTRUCTIONS("jdk8.AllInstructions", JdkVersion.JDK8),
        JDK8_ALL_STRUCTURES("jdk8.AllStructures", JdkVersion.JDK8),
        JDK8_ANONYMOUS_INNER_CLASS("jdk8.AllStructures$1", JdkVersion.JDK8),
        JDK8_ARTIFICIAL_STRUCTURES("jdk8.Artificial$()$Structures", JdkVersion.JDK8),
        JDK8_INNER_CLASS("jdk8.AllStructures$InnerClass", JdkVersion.JDK8),
        JDK8_LARGE_METHOD("jdk8.LargeMethod", JdkVersion.JDK8),
        JDK9_MODULE("jdk9.module-info", JdkVersion.JDK9),
        JDK11_ALL_INSTRUCTIONS("jdk11.AllInstructions", JdkVersion.JDK11),
        JDK11_ALL_STRUCTURES("jdk11.AllStructures", JdkVersion.JDK11),
        JDK11_ALL_STRUCTURES_NESTED("jdk11.AllStructures$Nested", JdkVersion.JDK11),
        JDK14_ALL_STRUCTURES_RECORD("jdk14.AllStructures$RecordSubType", JdkVersion.JDK14, true),
        JDK14_ALL_STRUCTURES_EMPTY_RECORD("jdk14.AllStructures$EmptyRecord", JdkVersion.JDK14, true),
        JDK15_ALL_STRUCTURES("jdk15.AllStructures", JdkVersion.JDK15, true);

        private final String name;
        private final JdkVersion jdkVersion;
        private final boolean preview;
        private byte[] bytes;

        private PrecompiledClass(String name, JdkVersion jdkVersion, boolean preview) {
            this.name = name;
            this.jdkVersion = jdkVersion;
            this.preview = preview;
        }

        private PrecompiledClass(String name, JdkVersion jdkVersion) {
            this(name, jdkVersion, false);
        }

        private PrecompiledClass(String name) {
            this(name, JdkVersion.JDK7, false);
        }

        public String getName() {
            return this.name;
        }

        public String getInternalName() {
            return this.name.endsWith("module-info") ? "module-info" : this.name.replace('.', '/');
        }

        public boolean isMoreRecentThan(Api api) {
            return api.value() < this.jdkVersion.minimumApi().value();
        }

        public boolean isNotCompatibleWithCurrentJdk() {
            if (this.preview) {
                if (!Util.previewFeatureEnabled()) {
                    return true;
                }
                return Util.getMajorJavaVersion() != this.jdkVersion.majorVersion();
            }
            return Util.getMajorJavaVersion() < this.jdkVersion.majorVersion();
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = AsmTest.getBytes(this.name, ".class");
            }
            return (byte[])this.bytes.clone();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum InvalidClass {
        INVALID_BYTECODE_OFFSET("invalid.InvalidBytecodeOffset"),
        INVALID_CLASS_VERSION("invalid.InvalidClassVersion"),
        INVALID_CODE_LENGTH("invalid.InvalidCodeLength"),
        INVALID_CONSTANT_POOL_INDEX("invalid.InvalidConstantPoolIndex"),
        INVALID_CONSTANT_POOL_REFERENCE("invalid.InvalidConstantPoolReference"),
        INVALID_CP_INFO_TAG("invalid.InvalidCpInfoTag"),
        INVALID_ELEMENT_VALUE("invalid.InvalidElementValue"),
        INVALID_INSN_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidInsnTypeAnnotationTargetType"),
        INVALID_OPCODE("invalid.InvalidOpcode"),
        INVALID_SOURCE_DEBUG_EXTENSION("invalid.InvalidSourceDebugExtension"),
        INVALID_STACK_MAP_FRAME_TYPE("invalid.InvalidStackMapFrameType"),
        INVALID_TYPE_ANNOTATION_TARGET_TYPE("invalid.InvalidTypeAnnotationTargetType"),
        INVALID_VERIFICATION_TYPE_INFO("invalid.InvalidVerificationTypeInfo"),
        INVALID_WIDE_OPCODE("invalid.InvalidWideOpcode");

        private final String name;

        private InvalidClass(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getBytes() {
            return AsmTest.getBytes(this.name, ".clazz");
        }

        public String toString() {
            return this.name;
        }
    }

    static enum JdkVersion {
        JDK7(7, Api.ASM4),
        JDK8(8, Api.ASM5),
        JDK9(9, Api.ASM6),
        JDK11(11, Api.ASM7),
        JDK14(14, Api.ASM8),
        JDK15(15, Api.ASM9);

        private final int majorVersion;
        private final Api minimumApi;

        private JdkVersion(int majorVersion, Api minimumApi) {
            this.majorVersion = majorVersion;
            this.minimumApi = minimumApi;
        }

        public int majorVersion() {
            return this.majorVersion;
        }

        public Api minimumApi() {
            return this.minimumApi;
        }
    }
}

